/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeAppliedSchemaResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, UpgradeAppliedSchemaResponse> {
    private static final SdkField<String> UPGRADED_SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpgradeAppliedSchemaResponse.getter(UpgradeAppliedSchemaResponse::upgradedSchemaArn)).setter(UpgradeAppliedSchemaResponse.setter(Builder::upgradedSchemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradedSchemaArn").build()}).build();
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpgradeAppliedSchemaResponse.getter(UpgradeAppliedSchemaResponse::directoryArn)).setter(UpgradeAppliedSchemaResponse.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADED_SCHEMA_ARN_FIELD, DIRECTORY_ARN_FIELD));
    private final String upgradedSchemaArn;
    private final String directoryArn;

    private UpgradeAppliedSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.upgradedSchemaArn = builder.upgradedSchemaArn;
        this.directoryArn = builder.directoryArn;
    }

    public String upgradedSchemaArn() {
        return this.upgradedSchemaArn;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradedSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeAppliedSchemaResponse)) {
            return false;
        }
        UpgradeAppliedSchemaResponse other = (UpgradeAppliedSchemaResponse)((Object)obj);
        return Objects.equals(this.upgradedSchemaArn(), other.upgradedSchemaArn()) && Objects.equals(this.directoryArn(), other.directoryArn());
    }

    public String toString() {
        return ToString.builder((String)"UpgradeAppliedSchemaResponse").add("UpgradedSchemaArn", (Object)this.upgradedSchemaArn()).add("DirectoryArn", (Object)this.directoryArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradedSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.upgradedSchemaArn()));
            }
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeAppliedSchemaResponse, T> g) {
        return obj -> g.apply((UpgradeAppliedSchemaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private String upgradedSchemaArn;
        private String directoryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeAppliedSchemaResponse model) {
            super(model);
            this.upgradedSchemaArn(model.upgradedSchemaArn);
            this.directoryArn(model.directoryArn);
        }

        public final String getUpgradedSchemaArn() {
            return this.upgradedSchemaArn;
        }

        @Override
        public final Builder upgradedSchemaArn(String upgradedSchemaArn) {
            this.upgradedSchemaArn = upgradedSchemaArn;
            return this;
        }

        public final void setUpgradedSchemaArn(String upgradedSchemaArn) {
            this.upgradedSchemaArn = upgradedSchemaArn;
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public UpgradeAppliedSchemaResponse build() {
            return new UpgradeAppliedSchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpgradeAppliedSchemaResponse> {
        public Builder upgradedSchemaArn(String var1);

        public Builder directoryArn(String var1);
    }
}

