/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudcontrol.CloudControlClient;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ProgressEvent;

public class ListResourceRequestsIterable
implements SdkIterable<ListResourceRequestsResponse> {
    private final CloudControlClient client;
    private final ListResourceRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceRequestsIterable(CloudControlClient client, ListResourceRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListResourceRequestsResponseFetcher();
    }

    public Iterator<ListResourceRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProgressEvent> resourceRequestStatusSummaries() {
        Function<ListResourceRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceRequestStatusSummaries() != null) {
                return response.resourceRequestStatusSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceRequestsResponseFetcher
    implements SyncPageFetcher<ListResourceRequestsResponse> {
        private ListResourceRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceRequestsResponse nextPage(ListResourceRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceRequestsIterable.this.client.listResourceRequests(ListResourceRequestsIterable.this.firstRequest);
            }
            return ListResourceRequestsIterable.this.client.listResourceRequests((ListResourceRequestsRequest)((Object)ListResourceRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

