/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloud9.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EnvironmentType {
    SSH("ssh"),
    EC2("ec2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EnvironmentType> VALUE_MAP;
    private final String value;

    private EnvironmentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnvironmentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnvironmentType> knownValues() {
        EnumSet<EnvironmentType> knownValues = EnumSet.allOf(EnvironmentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EnvironmentType.class, EnvironmentType::toString);
    }
}

