/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Request;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentEc2Response;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipRequest;
import software.amazon.awssdk.services.cloud9.model.CreateEnvironmentMembershipResponse;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipRequest;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentMembershipResponse;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentRequest;
import software.amazon.awssdk.services.cloud9.model.DeleteEnvironmentResponse;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentStatusResponse;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse;
import software.amazon.awssdk.services.cloud9.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloud9.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloud9.model.TagResourceRequest;
import software.amazon.awssdk.services.cloud9.model.TagResourceResponse;
import software.amazon.awssdk.services.cloud9.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloud9.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipRequest;
import software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentMembershipResponse;
import software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.services.cloud9.model.UpdateEnvironmentResponse;
import software.amazon.awssdk.services.cloud9.paginators.DescribeEnvironmentMembershipsPublisher;
import software.amazon.awssdk.services.cloud9.paginators.ListEnvironmentsPublisher;

/**
 * Service client for accessing AWS Cloud9 asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Cloud9</fullname>
 * <p>
 * Cloud9 is a collection of tools that you can use to code, build, run, test, debug, and release software in the cloud.
 * </p>
 * <p>
 * For more information about Cloud9, see the <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide">Cloud9 User
 * Guide</a>.
 * </p>
 * <p>
 * Cloud9 supports these operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>CreateEnvironmentEC2</code>: Creates an Cloud9 development environment, launches an Amazon EC2 instance, and
 * then connects from the instance to the environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CreateEnvironmentMembership</code>: Adds an environment member to an environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteEnvironment</code>: Deletes an environment. If an Amazon EC2 instance is connected to the environment,
 * also terminates the instance.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteEnvironmentMembership</code>: Deletes an environment member from an environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DescribeEnvironmentMemberships</code>: Gets information about environment members for an environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DescribeEnvironments</code>: Gets information about environments.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DescribeEnvironmentStatus</code>: Gets status information for an environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListEnvironments</code>: Gets a list of environment identifiers.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ListTagsForResource</code>: Gets the tags for an environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>TagResource</code>: Adds tags to an environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UntagResource</code>: Removes tags from an environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateEnvironment</code>: Changes the settings of an existing environment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateEnvironmentMembership</code>: Changes the settings of an existing environment member for an environment.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Cloud9AsyncClient extends SdkClient {
    String SERVICE_NAME = "cloud9";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloud9";

    /**
     * <p>
     * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and
     * then connects from the instance to the environment.
     * </p>
     *
     * @param createEnvironmentEc2Request
     * @return A Java Future containing the result of the CreateEnvironmentEC2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.CreateEnvironmentEC2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentEC2" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentEc2Response> createEnvironmentEC2(
            CreateEnvironmentEc2Request createEnvironmentEc2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and
     * then connects from the instance to the environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentEc2Request.Builder} avoiding the
     * need to create one manually via {@link CreateEnvironmentEc2Request#builder()}
     * </p>
     *
     * @param createEnvironmentEc2Request
     *        A {@link Consumer} that will call methods on {@link CreateEnvironmentEC2Request.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEnvironmentEC2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.CreateEnvironmentEC2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentEC2" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentEc2Response> createEnvironmentEC2(
            Consumer<CreateEnvironmentEc2Request.Builder> createEnvironmentEc2Request) {
        return createEnvironmentEC2(CreateEnvironmentEc2Request.builder().applyMutation(createEnvironmentEc2Request).build());
    }

    /**
     * <p>
     * Adds an environment member to an Cloud9 development environment.
     * </p>
     *
     * @param createEnvironmentMembershipRequest
     * @return A Java Future containing the result of the CreateEnvironmentMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.CreateEnvironmentMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentMembershipResponse> createEnvironmentMembership(
            CreateEnvironmentMembershipRequest createEnvironmentMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an environment member to an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEnvironmentMembershipRequest.Builder}
     * avoiding the need to create one manually via {@link CreateEnvironmentMembershipRequest#builder()}
     * </p>
     *
     * @param createEnvironmentMembershipRequest
     *        A {@link Consumer} that will call methods on {@link CreateEnvironmentMembershipRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateEnvironmentMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.CreateEnvironmentMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEnvironmentMembershipResponse> createEnvironmentMembership(
            Consumer<CreateEnvironmentMembershipRequest.Builder> createEnvironmentMembershipRequest) {
        return createEnvironmentMembership(CreateEnvironmentMembershipRequest.builder()
                .applyMutation(createEnvironmentMembershipRequest).build());
    }

    /**
     * <p>
     * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also
     * terminates the instance.
     * </p>
     *
     * @param deleteEnvironmentRequest
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(DeleteEnvironmentRequest deleteEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Cloud9 development environment. If an Amazon EC2 instance is connected to the environment, also
     * terminates the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEnvironmentRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DeleteEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentResponse> deleteEnvironment(
            Consumer<DeleteEnvironmentRequest.Builder> deleteEnvironmentRequest) {
        return deleteEnvironment(DeleteEnvironmentRequest.builder().applyMutation(deleteEnvironmentRequest).build());
    }

    /**
     * <p>
     * Deletes an environment member from a development environment.
     * </p>
     *
     * @param deleteEnvironmentMembershipRequest
     * @return A Java Future containing the result of the DeleteEnvironmentMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DeleteEnvironmentMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironmentMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentMembershipResponse> deleteEnvironmentMembership(
            DeleteEnvironmentMembershipRequest deleteEnvironmentMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an environment member from a development environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEnvironmentMembershipRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEnvironmentMembershipRequest#builder()}
     * </p>
     *
     * @param deleteEnvironmentMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEnvironmentMembershipRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteEnvironmentMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DeleteEnvironmentMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironmentMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEnvironmentMembershipResponse> deleteEnvironmentMembership(
            Consumer<DeleteEnvironmentMembershipRequest.Builder> deleteEnvironmentMembershipRequest) {
        return deleteEnvironmentMembership(DeleteEnvironmentMembershipRequest.builder()
                .applyMutation(deleteEnvironmentMembershipRequest).build());
    }

    /**
     * <p>
     * Gets information about environment members for an Cloud9 development environment.
     * </p>
     *
     * @param describeEnvironmentMembershipsRequest
     * @return A Java Future containing the result of the DescribeEnvironmentMemberships operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironmentMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentMembershipsResponse> describeEnvironmentMemberships(
            DescribeEnvironmentMembershipsRequest describeEnvironmentMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about environment members for an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentMembershipsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEnvironmentMembershipsRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentMembershipsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEnvironmentMemberships operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironmentMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentMembershipsResponse> describeEnvironmentMemberships(
            Consumer<DescribeEnvironmentMembershipsRequest.Builder> describeEnvironmentMembershipsRequest) {
        return describeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest.builder()
                .applyMutation(describeEnvironmentMembershipsRequest).build());
    }

    /**
     * <p>
     * Gets information about environment members for an Cloud9 development environment.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEnvironmentMemberships operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironmentMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentMembershipsResponse> describeEnvironmentMemberships() {
        return describeEnvironmentMemberships(DescribeEnvironmentMembershipsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about environment members for an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEnvironmentMemberships(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.DescribeEnvironmentMembershipsPublisher publisher = client.describeEnvironmentMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.DescribeEnvironmentMembershipsPublisher publisher = client.describeEnvironmentMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEnvironmentMemberships(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironmentMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentMembershipsPublisher describeEnvironmentMembershipsPaginator() {
        return describeEnvironmentMembershipsPaginator(DescribeEnvironmentMembershipsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about environment members for an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEnvironmentMemberships(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.DescribeEnvironmentMembershipsPublisher publisher = client.describeEnvironmentMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.DescribeEnvironmentMembershipsPublisher publisher = client.describeEnvironmentMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEnvironmentMemberships(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEnvironmentMembershipsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironmentMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentMembershipsPublisher describeEnvironmentMembershipsPaginator(
            DescribeEnvironmentMembershipsRequest describeEnvironmentMembershipsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about environment members for an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEnvironmentMemberships(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.DescribeEnvironmentMembershipsPublisher publisher = client.describeEnvironmentMembershipsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.DescribeEnvironmentMembershipsPublisher publisher = client.describeEnvironmentMembershipsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEnvironmentMemberships(software.amazon.awssdk.services.cloud9.model.DescribeEnvironmentMembershipsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentMembershipsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEnvironmentMembershipsRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentMembershipsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironmentMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEnvironmentMembershipsPublisher describeEnvironmentMembershipsPaginator(
            Consumer<DescribeEnvironmentMembershipsRequest.Builder> describeEnvironmentMembershipsRequest) {
        return describeEnvironmentMembershipsPaginator(DescribeEnvironmentMembershipsRequest.builder()
                .applyMutation(describeEnvironmentMembershipsRequest).build());
    }

    /**
     * <p>
     * Gets status information for an Cloud9 development environment.
     * </p>
     *
     * @param describeEnvironmentStatusRequest
     * @return A Java Future containing the result of the DescribeEnvironmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentStatusResponse> describeEnvironmentStatus(
            DescribeEnvironmentStatusRequest describeEnvironmentStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets status information for an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentStatusRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEnvironmentStatusRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEnvironmentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironmentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentStatusResponse> describeEnvironmentStatus(
            Consumer<DescribeEnvironmentStatusRequest.Builder> describeEnvironmentStatusRequest) {
        return describeEnvironmentStatus(DescribeEnvironmentStatusRequest.builder()
                .applyMutation(describeEnvironmentStatusRequest).build());
    }

    /**
     * <p>
     * Gets information about Cloud9 development environments.
     * </p>
     *
     * @param describeEnvironmentsRequest
     * @return A Java Future containing the result of the DescribeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentsResponse> describeEnvironments(
            DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about Cloud9 development environments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEnvironmentsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEnvironmentsRequest#builder()}
     * </p>
     *
     * @param describeEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEnvironmentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.DescribeEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironments" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEnvironmentsResponse> describeEnvironments(
            Consumer<DescribeEnvironmentsRequest.Builder> describeEnvironmentsRequest) {
        return describeEnvironments(DescribeEnvironmentsRequest.builder().applyMutation(describeEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of Cloud9 development environment identifiers.
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(ListEnvironmentsRequest listEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of Cloud9 development environment identifiers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListEnvironmentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments(
            Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironments(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of Cloud9 development environment identifiers.
     * </p>
     *
     * @return A Java Future containing the result of the ListEnvironments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEnvironmentsResponse> listEnvironments() {
        return listEnvironments(ListEnvironmentsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of Cloud9 development environment identifiers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator() {
        return listEnvironmentsPaginator(ListEnvironmentsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of Cloud9 development environment identifiers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     *
     * @param listEnvironmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(ListEnvironmentsRequest listEnvironmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of Cloud9 development environment identifiers.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEnvironments(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cloud9.paginators.ListEnvironmentsPublisher publisher = client.listEnvironmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnvironments(software.amazon.awssdk.services.cloud9.model.ListEnvironmentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnvironmentsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEnvironmentsRequest#builder()}
     * </p>
     *
     * @param listEnvironmentsRequest
     *        A {@link Consumer} that will call methods on {@link ListEnvironmentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.ListEnvironments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEnvironmentsPublisher listEnvironmentsPaginator(Consumer<ListEnvironmentsRequest.Builder> listEnvironmentsRequest) {
        return listEnvironmentsPaginator(ListEnvironmentsRequest.builder().applyMutation(listEnvironmentsRequest).build());
    }

    /**
     * <p>
     * Gets a list of the tags associated with an Cloud9 development environment.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the tags associated with an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds tags to an Cloud9 development environment.
     * </p>
     * <important>
     * <p>
     * Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to
     * underlying resources.
     * </p>
     * </important>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConcurrentAccessException A concurrent access issue occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to an Cloud9 development environment.
     * </p>
     * <important>
     * <p>
     * Tags that you add to an Cloud9 environment by using this method will NOT be automatically propagated to
     * underlying resources.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConcurrentAccessException A concurrent access issue occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Cloud9 development environment.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConcurrentAccessException A concurrent access issue occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConcurrentAccessException A concurrent access issue occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Changes the settings of an existing Cloud9 development environment.
     * </p>
     *
     * @param updateEnvironmentRequest
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the settings of an existing Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEnvironmentRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEnvironmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateEnvironment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.UpdateEnvironment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentResponse> updateEnvironment(
            Consumer<UpdateEnvironmentRequest.Builder> updateEnvironmentRequest) {
        return updateEnvironment(UpdateEnvironmentRequest.builder().applyMutation(updateEnvironmentRequest).build());
    }

    /**
     * <p>
     * Changes the settings of an existing environment member for an Cloud9 development environment.
     * </p>
     *
     * @param updateEnvironmentMembershipRequest
     * @return A Java Future containing the result of the UpdateEnvironmentMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.UpdateEnvironmentMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentMembershipResponse> updateEnvironmentMembership(
            UpdateEnvironmentMembershipRequest updateEnvironmentMembershipRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the settings of an existing environment member for an Cloud9 development environment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEnvironmentMembershipRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEnvironmentMembershipRequest#builder()}
     * </p>
     *
     * @param updateEnvironmentMembershipRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEnvironmentMembershipRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateEnvironmentMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The target request is invalid.</li>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>NotFoundException The target resource cannot be found.</li>
     *         <li>ForbiddenException An access permissions issue occurred.</li>
     *         <li>TooManyRequestsException Too many service requests were made over the given time period.</li>
     *         <li>LimitExceededException A service limit was exceeded.</li>
     *         <li>InternalServerErrorException An internal server error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Cloud9Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Cloud9AsyncClient.UpdateEnvironmentMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentMembership"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEnvironmentMembershipResponse> updateEnvironmentMembership(
            Consumer<UpdateEnvironmentMembershipRequest.Builder> updateEnvironmentMembershipRequest) {
        return updateEnvironmentMembership(UpdateEnvironmentMembershipRequest.builder()
                .applyMutation(updateEnvironmentMembershipRequest).build());
    }

    /**
     * Create a {@link Cloud9AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Cloud9AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Cloud9AsyncClient}.
     */
    static Cloud9AsyncClientBuilder builder() {
        return new DefaultCloud9AsyncClientBuilder();
    }
}
