/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentMembershipsRequest extends Cloud9Request implements
        ToCopyableBuilder<DescribeEnvironmentMembershipsRequest.Builder, DescribeEnvironmentMembershipsRequest> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userArn").getter(getter(DescribeEnvironmentMembershipsRequest::userArn))
            .setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(DescribeEnvironmentMembershipsRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("permissions")
            .getter(getter(DescribeEnvironmentMembershipsRequest::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeEnvironmentMembershipsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeEnvironmentMembershipsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD,
            ENVIRONMENT_ID_FIELD, PERMISSIONS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String userArn;

    private final String environmentId;

    private final List<String> permissions;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeEnvironmentMembershipsRequest(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.environmentId = builder.environmentId;
        this.permissions = builder.permissions;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is
     * specified, information about all environment members are returned.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value
     *         is specified, information about all environment members are returned.
     */
    public final String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The ID of the environment to get environment member information about.
     * </p>
     * 
     * @return The ID of the environment to get environment member information about.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The type of environment member permissions to get information about. Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>owner</code>: Owns the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-only</code>: Has read-only access to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-write</code>: Has read-write access to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, information about all environment members are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The type of environment member permissions to get information about. Available values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>owner</code>: Owns the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-only</code>: Has read-only access to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-write</code>: Has read-write access to the environment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If no value is specified, information about all environment members are returned.
     */
    public final List<Permissions> permissions() {
        return PermissionsListCopier.copyStringToEnum(permissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of environment member permissions to get information about. Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>owner</code>: Owns the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-only</code>: Has read-only access to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-write</code>: Has read-write access to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, information about all environment members are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The type of environment member permissions to get information about. Available values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>owner</code>: Owns the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-only</code>: Has read-only access to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-write</code>: Has read-write access to the environment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If no value is specified, information about all environment members are returned.
     */
    public final List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * During a previous call, if there are more than 25 items in the list, only the first 25 items are returned, along
     * with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this operation
     * again, adding the next token to the call. To get all of the items in the list, keep calling this operation with
     * each subsequent next token that is returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, if there are more than 25 items in the list, only the first 25 items are
     *         returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the
     *         list, call this operation again, adding the next token to the call. To get all of the items in the list,
     *         keep calling this operation with each subsequent next token that is returned, until no more next tokens
     *         are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of environment members to get information about.
     * </p>
     * 
     * @return The maximum number of environment members to get information about.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentMembershipsRequest)) {
            return false;
        }
        DescribeEnvironmentMembershipsRequest other = (DescribeEnvironmentMembershipsRequest) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(environmentId(), other.environmentId())
                && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentMembershipsRequest").add("UserArn", userArn())
                .add("EnvironmentId", environmentId()).add("Permissions", hasPermissions() ? permissionsAsStrings() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentMembershipsRequest, T> g) {
        return obj -> g.apply((DescribeEnvironmentMembershipsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentMembershipsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of an individual environment member to get information about. If no value is
         * specified, information about all environment members are returned.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of an individual environment member to get information about. If no
         *        value is specified, information about all environment members are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The ID of the environment to get environment member information about.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment to get environment member information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The type of environment member permissions to get information about. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>owner</code>: Owns the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-only</code>: Has read-only access to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-write</code>: Has read-write access to the environment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If no value is specified, information about all environment members are returned.
         * </p>
         * 
         * @param permissions
         *        The type of environment member permissions to get information about. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>owner</code>: Owns the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-only</code>: Has read-only access to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-write</code>: Has read-write access to the environment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If no value is specified, information about all environment members are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The type of environment member permissions to get information about. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>owner</code>: Owns the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-only</code>: Has read-only access to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-write</code>: Has read-write access to the environment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If no value is specified, information about all environment members are returned.
         * </p>
         * 
         * @param permissions
         *        The type of environment member permissions to get information about. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>owner</code>: Owns the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-only</code>: Has read-only access to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-write</code>: Has read-write access to the environment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If no value is specified, information about all environment members are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The type of environment member permissions to get information about. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>owner</code>: Owns the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-only</code>: Has read-only access to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-write</code>: Has read-write access to the environment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If no value is specified, information about all environment members are returned.
         * </p>
         * 
         * @param permissions
         *        The type of environment member permissions to get information about. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>owner</code>: Owns the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-only</code>: Has read-only access to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-write</code>: Has read-write access to the environment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If no value is specified, information about all environment members are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permissions> permissions);

        /**
         * <p>
         * The type of environment member permissions to get information about. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>owner</code>: Owns the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-only</code>: Has read-only access to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-write</code>: Has read-write access to the environment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If no value is specified, information about all environment members are returned.
         * </p>
         * 
         * @param permissions
         *        The type of environment member permissions to get information about. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>owner</code>: Owns the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-only</code>: Has read-only access to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-write</code>: Has read-write access to the environment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If no value is specified, information about all environment members are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permissions... permissions);

        /**
         * <p>
         * During a previous call, if there are more than 25 items in the list, only the first 25 items are returned,
         * along with a unique string called a <i>next token</i>. To get the next batch of items in the list, call this
         * operation again, adding the next token to the call. To get all of the items in the list, keep calling this
         * operation with each subsequent next token that is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, if there are more than 25 items in the list, only the first 25 items are
         *        returned, along with a unique string called a <i>next token</i>. To get the next batch of items in the
         *        list, call this operation again, adding the next token to the call. To get all of the items in the
         *        list, keep calling this operation with each subsequent next token that is returned, until no more next
         *        tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of environment members to get information about.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of environment members to get information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Cloud9Request.BuilderImpl implements Builder {
        private String userArn;

        private String environmentId;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentMembershipsRequest model) {
            super(model);
            userArn(model.userArn);
            environmentId(model.environmentId);
            permissionsWithStrings(model.permissions);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getUserArn() {
            return userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permissions> permissions) {
            this.permissions = PermissionsListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permissions... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEnvironmentMembershipsRequest build() {
            return new DescribeEnvironmentMembershipsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
