/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentMembershipsResponse extends Cloud9Response implements
        ToCopyableBuilder<DescribeEnvironmentMembershipsResponse.Builder, DescribeEnvironmentMembershipsResponse> {
    private static final SdkField<List<EnvironmentMember>> MEMBERSHIPS_FIELD = SdkField
            .<List<EnvironmentMember>> builder(MarshallingType.LIST)
            .memberName("memberships")
            .getter(getter(DescribeEnvironmentMembershipsResponse::memberships))
            .setter(setter(Builder::memberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeEnvironmentMembershipsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EnvironmentMember> memberships;

    private final String nextToken;

    private DescribeEnvironmentMembershipsResponse(BuilderImpl builder) {
        super(builder);
        this.memberships = builder.memberships;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Memberships property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMemberships() {
        return memberships != null && !(memberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the environment members for the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMemberships()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the environment members for the environment.
     */
    public List<EnvironmentMember> memberships() {
        return memberships;
    }

    /**
     * <p>
     * If there are more than 25 items in the list, only the first 25 items are returned, along with a unique string
     * called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the
     * next token to the call.
     * </p>
     * 
     * @return If there are more than 25 items in the list, only the first 25 items are returned, along with a unique
     *         string called a <i>next token</i>. To get the next batch of items in the list, call this operation again,
     *         adding the next token to the call.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMemberships() ? memberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentMembershipsResponse)) {
            return false;
        }
        DescribeEnvironmentMembershipsResponse other = (DescribeEnvironmentMembershipsResponse) obj;
        return hasMemberships() == other.hasMemberships() && Objects.equals(memberships(), other.memberships())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEnvironmentMembershipsResponse")
                .add("Memberships", hasMemberships() ? memberships() : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memberships":
            return Optional.ofNullable(clazz.cast(memberships()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentMembershipsResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentMembershipsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEnvironmentMembershipsResponse> {
        /**
         * <p>
         * Information about the environment members for the environment.
         * </p>
         * 
         * @param memberships
         *        Information about the environment members for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberships(Collection<EnvironmentMember> memberships);

        /**
         * <p>
         * Information about the environment members for the environment.
         * </p>
         * 
         * @param memberships
         *        Information about the environment members for the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberships(EnvironmentMember... memberships);

        /**
         * <p>
         * Information about the environment members for the environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentMember>.Builder} avoiding the
         * need to create one manually via {@link List<EnvironmentMember>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentMember>.Builder#build()} is called immediately
         * and its result is passed to {@link #memberships(List<EnvironmentMember>)}.
         * 
         * @param memberships
         *        a consumer that will call methods on {@link List<EnvironmentMember>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberships(List<EnvironmentMember>)
         */
        Builder memberships(Consumer<EnvironmentMember.Builder>... memberships);

        /**
         * <p>
         * If there are more than 25 items in the list, only the first 25 items are returned, along with a unique string
         * called a <i>next token</i>. To get the next batch of items in the list, call this operation again, adding the
         * next token to the call.
         * </p>
         * 
         * @param nextToken
         *        If there are more than 25 items in the list, only the first 25 items are returned, along with a unique
         *        string called a <i>next token</i>. To get the next batch of items in the list, call this operation
         *        again, adding the next token to the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Cloud9Response.BuilderImpl implements Builder {
        private List<EnvironmentMember> memberships = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentMembershipsResponse model) {
            super(model);
            memberships(model.memberships);
            nextToken(model.nextToken);
        }

        public final Collection<EnvironmentMember.Builder> getMemberships() {
            if (memberships instanceof SdkAutoConstructList) {
                return null;
            }
            return memberships != null ? memberships.stream().map(EnvironmentMember::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder memberships(Collection<EnvironmentMember> memberships) {
            this.memberships = EnvironmentMembersListCopier.copy(memberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberships(EnvironmentMember... memberships) {
            memberships(Arrays.asList(memberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberships(Consumer<EnvironmentMember.Builder>... memberships) {
            memberships(Stream.of(memberships).map(c -> EnvironmentMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMemberships(Collection<EnvironmentMember.BuilderImpl> memberships) {
            this.memberships = EnvironmentMembersListCopier.copyFromBuilder(memberships);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEnvironmentMembershipsResponse build() {
            return new DescribeEnvironmentMembershipsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
