/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceAsyncClient;
import software.amazon.awssdk.services.chimesdkvoice.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse;

public class ListProxySessionsPublisher
implements SdkPublisher<ListProxySessionsResponse> {
    private final ChimeSdkVoiceAsyncClient client;
    private final ListProxySessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProxySessionsPublisher(ChimeSdkVoiceAsyncClient client, ListProxySessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProxySessionsPublisher(ChimeSdkVoiceAsyncClient client, ListProxySessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProxySessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProxySessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListProxySessionsResponseFetcher
    implements AsyncPageFetcher<ListProxySessionsResponse> {
        private ListProxySessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListProxySessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProxySessionsResponse> nextPage(ListProxySessionsResponse previousPage) {
            if (previousPage == null) {
                return ListProxySessionsPublisher.this.client.listProxySessions(ListProxySessionsPublisher.this.firstRequest);
            }
            return ListProxySessionsPublisher.this.client.listProxySessions((ListProxySessionsRequest)((Object)ListProxySessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

