/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.SensitiveStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVoiceConnectorTerminationCredentialsResponse
extends ChimeSdkVoiceResponse
implements ToCopyableBuilder<Builder, ListVoiceConnectorTerminationCredentialsResponse> {
    private static final SdkField<List<String>> USERNAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Usernames").getter(ListVoiceConnectorTerminationCredentialsResponse.getter(ListVoiceConnectorTerminationCredentialsResponse::usernames)).setter(ListVoiceConnectorTerminationCredentialsResponse.setter(Builder::usernames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usernames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Usernames", USERNAMES_FIELD);
        }
    });
    private final List<String> usernames;

    private ListVoiceConnectorTerminationCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.usernames = builder.usernames;
    }

    public final boolean hasUsernames() {
        return this.usernames != null && !(this.usernames instanceof SdkAutoConstructList);
    }

    public final List<String> usernames() {
        return this.usernames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsernames() ? this.usernames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVoiceConnectorTerminationCredentialsResponse)) {
            return false;
        }
        ListVoiceConnectorTerminationCredentialsResponse other = (ListVoiceConnectorTerminationCredentialsResponse)((Object)obj);
        return this.hasUsernames() == other.hasUsernames() && Objects.equals(this.usernames(), other.usernames());
    }

    public final String toString() {
        return ToString.builder((String)"ListVoiceConnectorTerminationCredentialsResponse").add("Usernames", (Object)(this.usernames() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Usernames": {
                return Optional.ofNullable(clazz.cast(this.usernames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListVoiceConnectorTerminationCredentialsResponse, T> g) {
        return obj -> g.apply((ListVoiceConnectorTerminationCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceResponse.BuilderImpl
    implements Builder {
        private List<String> usernames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVoiceConnectorTerminationCredentialsResponse model) {
            super(model);
            this.usernames(model.usernames);
        }

        public final Collection<String> getUsernames() {
            if (this.usernames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.usernames;
        }

        public final void setUsernames(Collection<String> usernames) {
            this.usernames = SensitiveStringListCopier.copy(usernames);
        }

        @Override
        public final Builder usernames(Collection<String> usernames) {
            this.usernames = SensitiveStringListCopier.copy(usernames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernames(String ... usernames) {
            this.usernames(Arrays.asList(usernames));
            return this;
        }

        @Override
        public ListVoiceConnectorTerminationCredentialsResponse build() {
            return new ListVoiceConnectorTerminationCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVoiceConnectorTerminationCredentialsResponse> {
        public Builder usernames(Collection<String> var1);

        public Builder usernames(String ... var1);
    }
}

