/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GeoMatchLevel {
    COUNTRY("Country"),
    AREA_CODE("AreaCode"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GeoMatchLevel> VALUE_MAP;
    private final String value;

    private GeoMatchLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GeoMatchLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GeoMatchLevel> knownValues() {
        EnumSet<GeoMatchLevel> knownValues = EnumSet.allOf(GeoMatchLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GeoMatchLevel.class, GeoMatchLevel::toString);
    }
}

