/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChannelMessageType {
    STANDARD("STANDARD"),
    CONTROL("CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChannelMessageType> VALUE_MAP;
    private final String value;

    private ChannelMessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChannelMessageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChannelMessageType> knownValues() {
        EnumSet<ChannelMessageType> knownValues = EnumSet.allOf(ChannelMessageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChannelMessageType.class, ChannelMessageType::toString);
    }
}

