/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a channel member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelMembership.Builder, ChannelMembership> {
    private static final SdkField<Identity> INVITED_BY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("InvitedBy").getter(getter(ChannelMembership::invitedBy)).setter(setter(Builder::invitedBy))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedBy").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ChannelMembership::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Identity> MEMBER_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("Member").getter(getter(ChannelMembership::member)).setter(setter(Builder::member))
            .constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Member").build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ChannelMembership::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(ChannelMembership::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTimestamp").getter(getter(ChannelMembership::lastUpdatedTimestamp))
            .setter(setter(Builder::lastUpdatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build())
            .build();

    private static final SdkField<String> SUB_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubChannelId").getter(getter(ChannelMembership::subChannelId)).setter(setter(Builder::subChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubChannelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITED_BY_FIELD, TYPE_FIELD,
            MEMBER_FIELD, CHANNEL_ARN_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, SUB_CHANNEL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Identity invitedBy;

    private final String type;

    private final Identity member;

    private final String channelArn;

    private final Instant createdTimestamp;

    private final Instant lastUpdatedTimestamp;

    private final String subChannelId;

    private ChannelMembership(BuilderImpl builder) {
        this.invitedBy = builder.invitedBy;
        this.type = builder.type;
        this.member = builder.member;
        this.channelArn = builder.channelArn;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.subChannelId = builder.subChannelId;
    }

    /**
     * <p>
     * The identifier of the member who invited another member.
     * </p>
     * 
     * @return The identifier of the member who invited another member.
     */
    public final Identity invitedBy() {
        return invitedBy;
    }

    /**
     * <p>
     * The membership type set for the channel member.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership type set for the channel member.
     * @see ChannelMembershipType
     */
    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(type);
    }

    /**
     * <p>
     * The membership type set for the channel member.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ChannelMembershipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The membership type set for the channel member.
     * @see ChannelMembershipType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The data of the channel member.
     * </p>
     * 
     * @return The data of the channel member.
     */
    public final Identity member() {
        return member;
    }

    /**
     * <p>
     * The ARN of the member's channel.
     * </p>
     * 
     * @return The ARN of the member's channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The time at which the channel membership was created.
     * </p>
     * 
     * @return The time at which the channel membership was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which a channel membership was last updated.
     * </p>
     * 
     * @return The time at which a channel membership was last updated.
     */
    public final Instant lastUpdatedTimestamp() {
        return lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The ID of the SubChannel that a user belongs to.
     * </p>
     * 
     * @return The ID of the SubChannel that a user belongs to.
     */
    public final String subChannelId() {
        return subChannelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invitedBy());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(member());
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(subChannelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMembership)) {
            return false;
        }
        ChannelMembership other = (ChannelMembership) obj;
        return Objects.equals(invitedBy(), other.invitedBy()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(member(), other.member()) && Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(lastUpdatedTimestamp(), other.lastUpdatedTimestamp())
                && Objects.equals(subChannelId(), other.subChannelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelMembership").add("InvitedBy", invitedBy()).add("Type", typeAsString())
                .add("Member", member()).add("ChannelArn", channelArn()).add("CreatedTimestamp", createdTimestamp())
                .add("LastUpdatedTimestamp", lastUpdatedTimestamp()).add("SubChannelId", subChannelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvitedBy":
            return Optional.ofNullable(clazz.cast(invitedBy()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Member":
            return Optional.ofNullable(clazz.cast(member()));
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "LastUpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimestamp()));
        case "SubChannelId":
            return Optional.ofNullable(clazz.cast(subChannelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMembership, T> g) {
        return obj -> g.apply((ChannelMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelMembership> {
        /**
         * <p>
         * The identifier of the member who invited another member.
         * </p>
         * 
         * @param invitedBy
         *        The identifier of the member who invited another member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitedBy(Identity invitedBy);

        /**
         * <p>
         * The identifier of the member who invited another member.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #invitedBy(Identity)}.
         * 
         * @param invitedBy
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invitedBy(Identity)
         */
        default Builder invitedBy(Consumer<Identity.Builder> invitedBy) {
            return invitedBy(Identity.builder().applyMutation(invitedBy).build());
        }

        /**
         * <p>
         * The membership type set for the channel member.
         * </p>
         * 
         * @param type
         *        The membership type set for the channel member.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(String type);

        /**
         * <p>
         * The membership type set for the channel member.
         * </p>
         * 
         * @param type
         *        The membership type set for the channel member.
         * @see ChannelMembershipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMembershipType
         */
        Builder type(ChannelMembershipType type);

        /**
         * <p>
         * The data of the channel member.
         * </p>
         * 
         * @param member
         *        The data of the channel member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(Identity member);

        /**
         * <p>
         * The data of the channel member.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #member(Identity)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(Identity)
         */
        default Builder member(Consumer<Identity.Builder> member) {
            return member(Identity.builder().applyMutation(member).build());
        }

        /**
         * <p>
         * The ARN of the member's channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the member's channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The time at which the channel membership was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the channel membership was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which a channel membership was last updated.
         * </p>
         * 
         * @param lastUpdatedTimestamp
         *        The time at which a channel membership was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp);

        /**
         * <p>
         * The ID of the SubChannel that a user belongs to.
         * </p>
         * 
         * @param subChannelId
         *        The ID of the SubChannel that a user belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subChannelId(String subChannelId);
    }

    static final class BuilderImpl implements Builder {
        private Identity invitedBy;

        private String type;

        private Identity member;

        private String channelArn;

        private Instant createdTimestamp;

        private Instant lastUpdatedTimestamp;

        private String subChannelId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMembership model) {
            invitedBy(model.invitedBy);
            type(model.type);
            member(model.member);
            channelArn(model.channelArn);
            createdTimestamp(model.createdTimestamp);
            lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            subChannelId(model.subChannelId);
        }

        public final Identity.Builder getInvitedBy() {
            return invitedBy != null ? invitedBy.toBuilder() : null;
        }

        public final void setInvitedBy(Identity.BuilderImpl invitedBy) {
            this.invitedBy = invitedBy != null ? invitedBy.build() : null;
        }

        @Override
        public final Builder invitedBy(Identity invitedBy) {
            this.invitedBy = invitedBy;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Identity.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(Identity.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        public final Builder member(Identity member) {
            this.member = member;
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getSubChannelId() {
            return subChannelId;
        }

        public final void setSubChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
        }

        @Override
        public final Builder subChannelId(String subChannelId) {
            this.subChannelId = subChannelId;
            return this;
        }

        @Override
        public ChannelMembership build() {
            return new ChannelMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
