/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelFlowCallbackRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<ChannelFlowCallbackRequest.Builder, ChannelFlowCallbackRequest> {
    private static final SdkField<String> CALLBACK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallbackId")
            .getter(getter(ChannelFlowCallbackRequest::callbackId))
            .setter(setter(Builder::callbackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(ChannelFlowCallbackRequest::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<Boolean> DELETE_RESOURCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteResource").getter(getter(ChannelFlowCallbackRequest::deleteResource))
            .setter(setter(Builder::deleteResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteResource").build()).build();

    private static final SdkField<ChannelMessageCallback> CHANNEL_MESSAGE_FIELD = SdkField
            .<ChannelMessageCallback> builder(MarshallingType.SDK_POJO).memberName("ChannelMessage")
            .getter(getter(ChannelFlowCallbackRequest::channelMessage)).setter(setter(Builder::channelMessage))
            .constructor(ChannelMessageCallback::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLBACK_ID_FIELD,
            CHANNEL_ARN_FIELD, DELETE_RESOURCE_FIELD, CHANNEL_MESSAGE_FIELD));

    private final String callbackId;

    private final String channelArn;

    private final Boolean deleteResource;

    private final ChannelMessageCallback channelMessage;

    private ChannelFlowCallbackRequest(BuilderImpl builder) {
        super(builder);
        this.callbackId = builder.callbackId;
        this.channelArn = builder.channelArn;
        this.deleteResource = builder.deleteResource;
        this.channelMessage = builder.channelMessage;
    }

    /**
     * <p>
     * The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.
     * </p>
     * 
     * @return The identifier passed to the processor by the service when invoked. Use the identifier to call back the
     *         service.
     */
    public final String callbackId() {
        return callbackId;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of
     * true.
     * </p>
     * 
     * @return When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a
     *         value of true.
     */
    public final Boolean deleteResource() {
        return deleteResource;
    }

    /**
     * <p>
     * Stores information about the processed message.
     * </p>
     * 
     * @return Stores information about the processed message.
     */
    public final ChannelMessageCallback channelMessage() {
        return channelMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callbackId());
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(deleteResource());
        hashCode = 31 * hashCode + Objects.hashCode(channelMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelFlowCallbackRequest)) {
            return false;
        }
        ChannelFlowCallbackRequest other = (ChannelFlowCallbackRequest) obj;
        return Objects.equals(callbackId(), other.callbackId()) && Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(deleteResource(), other.deleteResource())
                && Objects.equals(channelMessage(), other.channelMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelFlowCallbackRequest").add("CallbackId", callbackId()).add("ChannelArn", channelArn())
                .add("DeleteResource", deleteResource()).add("ChannelMessage", channelMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallbackId":
            return Optional.ofNullable(clazz.cast(callbackId()));
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "DeleteResource":
            return Optional.ofNullable(clazz.cast(deleteResource()));
        case "ChannelMessage":
            return Optional.ofNullable(clazz.cast(channelMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelFlowCallbackRequest, T> g) {
        return obj -> g.apply((ChannelFlowCallbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ChannelFlowCallbackRequest> {
        /**
         * <p>
         * The identifier passed to the processor by the service when invoked. Use the identifier to call back the
         * service.
         * </p>
         * 
         * @param callbackId
         *        The identifier passed to the processor by the service when invoked. Use the identifier to call back
         *        the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackId(String callbackId);

        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value
         * of true.
         * </p>
         * 
         * @param deleteResource
         *        When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a
         *        value of true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteResource(Boolean deleteResource);

        /**
         * <p>
         * Stores information about the processed message.
         * </p>
         * 
         * @param channelMessage
         *        Stores information about the processed message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMessage(ChannelMessageCallback channelMessage);

        /**
         * <p>
         * Stores information about the processed message.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelMessageCallback.Builder} avoiding
         * the need to create one manually via {@link ChannelMessageCallback#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelMessageCallback.Builder#build()} is called immediately and
         * its result is passed to {@link #channelMessage(ChannelMessageCallback)}.
         * 
         * @param channelMessage
         *        a consumer that will call methods on {@link ChannelMessageCallback.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMessage(ChannelMessageCallback)
         */
        default Builder channelMessage(Consumer<ChannelMessageCallback.Builder> channelMessage) {
            return channelMessage(ChannelMessageCallback.builder().applyMutation(channelMessage).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String callbackId;

        private String channelArn;

        private Boolean deleteResource;

        private ChannelMessageCallback channelMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelFlowCallbackRequest model) {
            super(model);
            callbackId(model.callbackId);
            channelArn(model.channelArn);
            deleteResource(model.deleteResource);
            channelMessage(model.channelMessage);
        }

        public final String getCallbackId() {
            return callbackId;
        }

        public final void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @Override
        public final Builder callbackId(String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Boolean getDeleteResource() {
            return deleteResource;
        }

        public final void setDeleteResource(Boolean deleteResource) {
            this.deleteResource = deleteResource;
        }

        @Override
        public final Builder deleteResource(Boolean deleteResource) {
            this.deleteResource = deleteResource;
            return this;
        }

        public final ChannelMessageCallback.Builder getChannelMessage() {
            return channelMessage != null ? channelMessage.toBuilder() : null;
        }

        public final void setChannelMessage(ChannelMessageCallback.BuilderImpl channelMessage) {
            this.channelMessage = channelMessage != null ? channelMessage.build() : null;
        }

        @Override
        public final Builder channelMessage(ChannelMessageCallback channelMessage) {
            this.channelMessage = channelMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChannelFlowCallbackRequest build() {
            return new ChannelFlowCallbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
