/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingClient;
import software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.SearchChannelsResponse;

public class SearchChannelsIterable
implements SdkIterable<SearchChannelsResponse> {
    private final ChimeSdkMessagingClient client;
    private final SearchChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchChannelsIterable(ChimeSdkMessagingClient client, SearchChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchChannelsResponseFetcher();
    }

    public Iterator<SearchChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchChannelsResponseFetcher
    implements SyncPageFetcher<SearchChannelsResponse> {
        private SearchChannelsResponseFetcher() {
        }

        public boolean hasNextPage(SearchChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchChannelsResponse nextPage(SearchChannelsResponse previousPage) {
            if (previousPage == null) {
                return SearchChannelsIterable.this.client.searchChannels(SearchChannelsIterable.this.firstRequest);
            }
            return SearchChannelsIterable.this.client.searchChannels((SearchChannelsRequest)((Object)SearchChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

