/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for an Amazon Lex V2 bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LexConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LexConfiguration.Builder, LexConfiguration> {
    private static final SdkField<String> RESPONDS_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RespondsTo").getter(getter(LexConfiguration::respondsToAsString)).setter(setter(Builder::respondsTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RespondsTo").build()).build();

    private static final SdkField<InvokedBy> INVOKED_BY_FIELD = SdkField.<InvokedBy> builder(MarshallingType.SDK_POJO)
            .memberName("InvokedBy").getter(getter(LexConfiguration::invokedBy)).setter(setter(Builder::invokedBy))
            .constructor(InvokedBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokedBy").build()).build();

    private static final SdkField<String> LEX_BOT_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LexBotAliasArn").getter(getter(LexConfiguration::lexBotAliasArn))
            .setter(setter(Builder::lexBotAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBotAliasArn").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocaleId").getter(getter(LexConfiguration::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocaleId").build()).build();

    private static final SdkField<String> WELCOME_INTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WelcomeIntent").getter(getter(LexConfiguration::welcomeIntent)).setter(setter(Builder::welcomeIntent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WelcomeIntent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONDS_TO_FIELD,
            INVOKED_BY_FIELD, LEX_BOT_ALIAS_ARN_FIELD, LOCALE_ID_FIELD, WELCOME_INTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("RespondsTo", RESPONDS_TO_FIELD);
                    put("InvokedBy", INVOKED_BY_FIELD);
                    put("LexBotAliasArn", LEX_BOT_ALIAS_ARN_FIELD);
                    put("LocaleId", LOCALE_ID_FIELD);
                    put("WelcomeIntent", WELCOME_INTENT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String respondsTo;

    private final InvokedBy invokedBy;

    private final String lexBotAliasArn;

    private final String localeId;

    private final String welcomeIntent;

    private LexConfiguration(BuilderImpl builder) {
        this.respondsTo = builder.respondsTo;
        this.invokedBy = builder.invokedBy;
        this.lexBotAliasArn = builder.lexBotAliasArn;
        this.localeId = builder.localeId;
        this.welcomeIntent = builder.welcomeIntent;
    }

    /**
     * <important>
     * <p>
     * <b>Deprecated</b>. Use <code>InvokedBy</code> instead.
     * </p>
     * </important>
     * <p>
     * Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #respondsTo} will
     * return {@link RespondsTo#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #respondsToAsString}.
     * </p>
     * 
     * @return <p>
     *         <b>Deprecated</b>. Use <code>InvokedBy</code> instead.
     *         </p>
     *         </important>
     *         <p>
     *         Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not
     *         supported.
     * @see RespondsTo
     */
    public final RespondsTo respondsTo() {
        return RespondsTo.fromValue(respondsTo);
    }

    /**
     * <important>
     * <p>
     * <b>Deprecated</b>. Use <code>InvokedBy</code> instead.
     * </p>
     * </important>
     * <p>
     * Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #respondsTo} will
     * return {@link RespondsTo#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #respondsToAsString}.
     * </p>
     * 
     * @return <p>
     *         <b>Deprecated</b>. Use <code>InvokedBy</code> instead.
     *         </p>
     *         </important>
     *         <p>
     *         Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not
     *         supported.
     * @see RespondsTo
     */
    public final String respondsToAsString() {
        return respondsTo;
    }

    /**
     * <p>
     * Specifies the type of message that triggers a bot.
     * </p>
     * 
     * @return Specifies the type of message that triggers a bot.
     */
    public final InvokedBy invokedBy() {
        return invokedBy;
    }

    /**
     * <p>
     * The ARN of the Amazon Lex V2 bot's alias. The ARN uses this format:
     * <code>arn:aws:lex:REGION:ACCOUNT:bot-alias/MYBOTID/MYBOTALIAS</code>
     * </p>
     * 
     * @return The ARN of the Amazon Lex V2 bot's alias. The ARN uses this format:
     *         <code>arn:aws:lex:REGION:ACCOUNT:bot-alias/MYBOTID/MYBOTALIAS</code>
     */
    public final String lexBotAliasArn() {
        return lexBotAliasArn;
    }

    /**
     * <p>
     * Identifies the Amazon Lex V2 bot's language and locale. The string must match one of the supported locales in
     * Amazon Lex V2. All of the intents, slot types, and slots used in the bot must have the same locale. For more
     * information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>
     * in the <i>Amazon Lex V2 Developer Guide</i>.
     * </p>
     * 
     * @return Identifies the Amazon Lex V2 bot's language and locale. The string must match one of the supported
     *         locales in Amazon Lex V2. All of the intents, slot types, and slots used in the bot must have the same
     *         locale. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> in the
     *         <i>Amazon Lex V2 Developer Guide</i>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The name of the welcome intent configured in the Amazon Lex V2 bot.
     * </p>
     * 
     * @return The name of the welcome intent configured in the Amazon Lex V2 bot.
     */
    public final String welcomeIntent() {
        return welcomeIntent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(respondsToAsString());
        hashCode = 31 * hashCode + Objects.hashCode(invokedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lexBotAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(welcomeIntent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexConfiguration)) {
            return false;
        }
        LexConfiguration other = (LexConfiguration) obj;
        return Objects.equals(respondsToAsString(), other.respondsToAsString()) && Objects.equals(invokedBy(), other.invokedBy())
                && Objects.equals(lexBotAliasArn(), other.lexBotAliasArn()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(welcomeIntent(), other.welcomeIntent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LexConfiguration").add("RespondsTo", respondsToAsString()).add("InvokedBy", invokedBy())
                .add("LexBotAliasArn", lexBotAliasArn()).add("LocaleId", localeId()).add("WelcomeIntent", welcomeIntent())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RespondsTo":
            return Optional.ofNullable(clazz.cast(respondsToAsString()));
        case "InvokedBy":
            return Optional.ofNullable(clazz.cast(invokedBy()));
        case "LexBotAliasArn":
            return Optional.ofNullable(clazz.cast(lexBotAliasArn()));
        case "LocaleId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "WelcomeIntent":
            return Optional.ofNullable(clazz.cast(welcomeIntent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LexConfiguration, T> g) {
        return obj -> g.apply((LexConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LexConfiguration> {
        /**
         * <important>
         * <p>
         * <b>Deprecated</b>. Use <code>InvokedBy</code> instead.
         * </p>
         * </important>
         * <p>
         * Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not
         * supported.
         * </p>
         * 
         * @param respondsTo
         *        <p>
         *        <b>Deprecated</b>. Use <code>InvokedBy</code> instead.
         *        </p>
         *        </important>
         *        <p>
         *        Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not
         *        supported.
         * @see RespondsTo
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RespondsTo
         */
        Builder respondsTo(String respondsTo);

        /**
         * <important>
         * <p>
         * <b>Deprecated</b>. Use <code>InvokedBy</code> instead.
         * </p>
         * </important>
         * <p>
         * Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not
         * supported.
         * </p>
         * 
         * @param respondsTo
         *        <p>
         *        <b>Deprecated</b>. Use <code>InvokedBy</code> instead.
         *        </p>
         *        </important>
         *        <p>
         *        Determines whether the Amazon Lex V2 bot responds to all standard messages. Control messages are not
         *        supported.
         * @see RespondsTo
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RespondsTo
         */
        Builder respondsTo(RespondsTo respondsTo);

        /**
         * <p>
         * Specifies the type of message that triggers a bot.
         * </p>
         * 
         * @param invokedBy
         *        Specifies the type of message that triggers a bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedBy(InvokedBy invokedBy);

        /**
         * <p>
         * Specifies the type of message that triggers a bot.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvokedBy.Builder} avoiding the need to
         * create one manually via {@link InvokedBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvokedBy.Builder#build()} is called immediately and its result
         * is passed to {@link #invokedBy(InvokedBy)}.
         * 
         * @param invokedBy
         *        a consumer that will call methods on {@link InvokedBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invokedBy(InvokedBy)
         */
        default Builder invokedBy(Consumer<InvokedBy.Builder> invokedBy) {
            return invokedBy(InvokedBy.builder().applyMutation(invokedBy).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Lex V2 bot's alias. The ARN uses this format:
         * <code>arn:aws:lex:REGION:ACCOUNT:bot-alias/MYBOTID/MYBOTALIAS</code>
         * </p>
         * 
         * @param lexBotAliasArn
         *        The ARN of the Amazon Lex V2 bot's alias. The ARN uses this format:
         *        <code>arn:aws:lex:REGION:ACCOUNT:bot-alias/MYBOTID/MYBOTALIAS</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexBotAliasArn(String lexBotAliasArn);

        /**
         * <p>
         * Identifies the Amazon Lex V2 bot's language and locale. The string must match one of the supported locales in
         * Amazon Lex V2. All of the intents, slot types, and slots used in the bot must have the same locale. For more
         * information, see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported
         * languages</a> in the <i>Amazon Lex V2 Developer Guide</i>.
         * </p>
         * 
         * @param localeId
         *        Identifies the Amazon Lex V2 bot's language and locale. The string must match one of the supported
         *        locales in Amazon Lex V2. All of the intents, slot types, and slots used in the bot must have the same
         *        locale. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a> in the
         *        <i>Amazon Lex V2 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The name of the welcome intent configured in the Amazon Lex V2 bot.
         * </p>
         * 
         * @param welcomeIntent
         *        The name of the welcome intent configured in the Amazon Lex V2 bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder welcomeIntent(String welcomeIntent);
    }

    static final class BuilderImpl implements Builder {
        private String respondsTo;

        private InvokedBy invokedBy;

        private String lexBotAliasArn;

        private String localeId;

        private String welcomeIntent;

        private BuilderImpl() {
        }

        private BuilderImpl(LexConfiguration model) {
            respondsTo(model.respondsTo);
            invokedBy(model.invokedBy);
            lexBotAliasArn(model.lexBotAliasArn);
            localeId(model.localeId);
            welcomeIntent(model.welcomeIntent);
        }

        public final String getRespondsTo() {
            return respondsTo;
        }

        public final void setRespondsTo(String respondsTo) {
            this.respondsTo = respondsTo;
        }

        @Override
        public final Builder respondsTo(String respondsTo) {
            this.respondsTo = respondsTo;
            return this;
        }

        @Override
        public final Builder respondsTo(RespondsTo respondsTo) {
            this.respondsTo(respondsTo == null ? null : respondsTo.toString());
            return this;
        }

        public final InvokedBy.Builder getInvokedBy() {
            return invokedBy != null ? invokedBy.toBuilder() : null;
        }

        public final void setInvokedBy(InvokedBy.BuilderImpl invokedBy) {
            this.invokedBy = invokedBy != null ? invokedBy.build() : null;
        }

        @Override
        public final Builder invokedBy(InvokedBy invokedBy) {
            this.invokedBy = invokedBy;
            return this;
        }

        public final String getLexBotAliasArn() {
            return lexBotAliasArn;
        }

        public final void setLexBotAliasArn(String lexBotAliasArn) {
            this.lexBotAliasArn = lexBotAliasArn;
        }

        @Override
        public final Builder lexBotAliasArn(String lexBotAliasArn) {
            this.lexBotAliasArn = lexBotAliasArn;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getWelcomeIntent() {
            return welcomeIntent;
        }

        public final void setWelcomeIntent(String welcomeIntent) {
            this.welcomeIntent = welcomeIntent;
        }

        @Override
        public final Builder welcomeIntent(String welcomeIntent) {
            this.welcomeIntent = welcomeIntent;
            return this;
        }

        @Override
        public LexConfiguration build() {
            return new LexConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
