/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes of an <code>Endpoint</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointAttributes.Builder, EndpointAttributes> {
    private static final SdkField<String> DEVICE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceToken").getter(getter(EndpointAttributes::deviceToken)).setter(setter(Builder::deviceToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceToken").build()).build();

    private static final SdkField<String> VOIP_DEVICE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoipDeviceToken").getter(getter(EndpointAttributes::voipDeviceToken))
            .setter(setter(Builder::voipDeviceToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoipDeviceToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_TOKEN_FIELD,
            VOIP_DEVICE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DeviceToken", DEVICE_TOKEN_FIELD);
                    put("VoipDeviceToken", VOIP_DEVICE_TOKEN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String deviceToken;

    private final String voipDeviceToken;

    private EndpointAttributes(BuilderImpl builder) {
        this.deviceToken = builder.deviceToken;
        this.voipDeviceToken = builder.voipDeviceToken;
    }

    /**
     * <p>
     * The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.
     * </p>
     * 
     * @return The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.
     */
    public final String deviceToken() {
        return deviceToken;
    }

    /**
     * <p>
     * The VOIP device token for the APNS and APNS_SANDBOX endpoint types.
     * </p>
     * 
     * @return The VOIP device token for the APNS and APNS_SANDBOX endpoint types.
     */
    public final String voipDeviceToken() {
        return voipDeviceToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceToken());
        hashCode = 31 * hashCode + Objects.hashCode(voipDeviceToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointAttributes)) {
            return false;
        }
        EndpointAttributes other = (EndpointAttributes) obj;
        return Objects.equals(deviceToken(), other.deviceToken()) && Objects.equals(voipDeviceToken(), other.voipDeviceToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointAttributes")
                .add("DeviceToken", deviceToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VoipDeviceToken", voipDeviceToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceToken":
            return Optional.ofNullable(clazz.cast(deviceToken()));
        case "VoipDeviceToken":
            return Optional.ofNullable(clazz.cast(voipDeviceToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EndpointAttributes, T> g) {
        return obj -> g.apply((EndpointAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointAttributes> {
        /**
         * <p>
         * The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.
         * </p>
         * 
         * @param deviceToken
         *        The device token for the GCM, APNS, and APNS_SANDBOX endpoint types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceToken(String deviceToken);

        /**
         * <p>
         * The VOIP device token for the APNS and APNS_SANDBOX endpoint types.
         * </p>
         * 
         * @param voipDeviceToken
         *        The VOIP device token for the APNS and APNS_SANDBOX endpoint types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voipDeviceToken(String voipDeviceToken);
    }

    static final class BuilderImpl implements Builder {
        private String deviceToken;

        private String voipDeviceToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointAttributes model) {
            deviceToken(model.deviceToken);
            voipDeviceToken(model.voipDeviceToken);
        }

        public final String getDeviceToken() {
            return deviceToken;
        }

        public final void setDeviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
        }

        @Override
        public final Builder deviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
            return this;
        }

        public final String getVoipDeviceToken() {
            return voipDeviceToken;
        }

        public final void setVoipDeviceToken(String voipDeviceToken) {
            this.voipDeviceToken = voipDeviceToken;
        }

        @Override
        public final Builder voipDeviceToken(String voipDeviceToken) {
            this.voipDeviceToken = voipDeviceToken;
            return this;
        }

        @Override
        public EndpointAttributes build() {
            return new EndpointAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
