/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppInstanceUserEndpointResponse extends ChimeSdkIdentityResponse implements
        ToCopyableBuilder<DescribeAppInstanceUserEndpointResponse.Builder, DescribeAppInstanceUserEndpointResponse> {
    private static final SdkField<AppInstanceUserEndpoint> APP_INSTANCE_USER_ENDPOINT_FIELD = SdkField
            .<AppInstanceUserEndpoint> builder(MarshallingType.SDK_POJO).memberName("AppInstanceUserEndpoint")
            .getter(getter(DescribeAppInstanceUserEndpointResponse::appInstanceUserEndpoint))
            .setter(setter(Builder::appInstanceUserEndpoint)).constructor(AppInstanceUserEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceUserEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APP_INSTANCE_USER_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AppInstanceUserEndpoint", APP_INSTANCE_USER_ENDPOINT_FIELD);
                }
            });

    private final AppInstanceUserEndpoint appInstanceUserEndpoint;

    private DescribeAppInstanceUserEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceUserEndpoint = builder.appInstanceUserEndpoint;
    }

    /**
     * <p>
     * The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name, type,
     * resource ARN, attributes, allow messages, state, and created and last updated timestamps. All timestamps use
     * epoch milliseconds.
     * </p>
     * 
     * @return The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID,
     *         name, type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All
     *         timestamps use epoch milliseconds.
     */
    public final AppInstanceUserEndpoint appInstanceUserEndpoint() {
        return appInstanceUserEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceUserEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppInstanceUserEndpointResponse)) {
            return false;
        }
        DescribeAppInstanceUserEndpointResponse other = (DescribeAppInstanceUserEndpointResponse) obj;
        return Objects.equals(appInstanceUserEndpoint(), other.appInstanceUserEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppInstanceUserEndpointResponse")
                .add("AppInstanceUserEndpoint", appInstanceUserEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceUserEndpoint":
            return Optional.ofNullable(clazz.cast(appInstanceUserEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppInstanceUserEndpointResponse, T> g) {
        return obj -> g.apply((DescribeAppInstanceUserEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkIdentityResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAppInstanceUserEndpointResponse> {
        /**
         * <p>
         * The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name,
         * type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All
         * timestamps use epoch milliseconds.
         * </p>
         * 
         * @param appInstanceUserEndpoint
         *        The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID,
         *        name, type, resource ARN, attributes, allow messages, state, and created and last updated timestamps.
         *        All timestamps use epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appInstanceUserEndpoint(AppInstanceUserEndpoint appInstanceUserEndpoint);

        /**
         * <p>
         * The full details of an <code>AppInstanceUserEndpoint</code>: the <code>AppInstanceUserArn</code>, ID, name,
         * type, resource ARN, attributes, allow messages, state, and created and last updated timestamps. All
         * timestamps use epoch milliseconds.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppInstanceUserEndpoint.Builder} avoiding
         * the need to create one manually via {@link AppInstanceUserEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppInstanceUserEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #appInstanceUserEndpoint(AppInstanceUserEndpoint)}.
         * 
         * @param appInstanceUserEndpoint
         *        a consumer that will call methods on {@link AppInstanceUserEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appInstanceUserEndpoint(AppInstanceUserEndpoint)
         */
        default Builder appInstanceUserEndpoint(Consumer<AppInstanceUserEndpoint.Builder> appInstanceUserEndpoint) {
            return appInstanceUserEndpoint(AppInstanceUserEndpoint.builder().applyMutation(appInstanceUserEndpoint).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkIdentityResponse.BuilderImpl implements Builder {
        private AppInstanceUserEndpoint appInstanceUserEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppInstanceUserEndpointResponse model) {
            super(model);
            appInstanceUserEndpoint(model.appInstanceUserEndpoint);
        }

        public final AppInstanceUserEndpoint.Builder getAppInstanceUserEndpoint() {
            return appInstanceUserEndpoint != null ? appInstanceUserEndpoint.toBuilder() : null;
        }

        public final void setAppInstanceUserEndpoint(AppInstanceUserEndpoint.BuilderImpl appInstanceUserEndpoint) {
            this.appInstanceUserEndpoint = appInstanceUserEndpoint != null ? appInstanceUserEndpoint.build() : null;
        }

        @Override
        public final Builder appInstanceUserEndpoint(AppInstanceUserEndpoint appInstanceUserEndpoint) {
            this.appInstanceUserEndpoint = appInstanceUserEndpoint;
            return this;
        }

        @Override
        public DescribeAppInstanceUserEndpointResponse build() {
            return new DescribeAppInstanceUserEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
