/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse;

public class ListVoiceConnectorGroupsIterable
implements SdkIterable<ListVoiceConnectorGroupsResponse> {
    private final ChimeClient client;
    private final ListVoiceConnectorGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVoiceConnectorGroupsIterable(ChimeClient client, ListVoiceConnectorGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVoiceConnectorGroupsResponseFetcher();
    }

    public Iterator<ListVoiceConnectorGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVoiceConnectorGroupsResponseFetcher
    implements SyncPageFetcher<ListVoiceConnectorGroupsResponse> {
        private ListVoiceConnectorGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListVoiceConnectorGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVoiceConnectorGroupsResponse nextPage(ListVoiceConnectorGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListVoiceConnectorGroupsIterable.this.client.listVoiceConnectorGroups(ListVoiceConnectorGroupsIterable.this.firstRequest);
            }
            return ListVoiceConnectorGroupsIterable.this.client.listVoiceConnectorGroups((ListVoiceConnectorGroupsRequest)((Object)ListVoiceConnectorGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

