/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.BatchChannelMemberships;
import software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipError;
import software.amazon.awssdk.services.chime.model.BatchCreateChannelMembershipErrorsCopier;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateChannelMembershipResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, BatchCreateChannelMembershipResponse> {
    private static final SdkField<BatchChannelMemberships> BATCH_CHANNEL_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BatchChannelMemberships").getter(BatchCreateChannelMembershipResponse.getter(BatchCreateChannelMembershipResponse::batchChannelMemberships)).setter(BatchCreateChannelMembershipResponse.setter(Builder::batchChannelMemberships)).constructor(BatchChannelMemberships::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchChannelMemberships").build()}).build();
    private static final SdkField<List<BatchCreateChannelMembershipError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchCreateChannelMembershipResponse.getter(BatchCreateChannelMembershipResponse::errors)).setter(BatchCreateChannelMembershipResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateChannelMembershipError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_CHANNEL_MEMBERSHIPS_FIELD, ERRORS_FIELD));
    private final BatchChannelMemberships batchChannelMemberships;
    private final List<BatchCreateChannelMembershipError> errors;

    private BatchCreateChannelMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.batchChannelMemberships = builder.batchChannelMemberships;
        this.errors = builder.errors;
    }

    public final BatchChannelMemberships batchChannelMemberships() {
        return this.batchChannelMemberships;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateChannelMembershipError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.batchChannelMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateChannelMembershipResponse)) {
            return false;
        }
        BatchCreateChannelMembershipResponse other = (BatchCreateChannelMembershipResponse)((Object)obj);
        return Objects.equals(this.batchChannelMemberships(), other.batchChannelMemberships()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateChannelMembershipResponse").add("BatchChannelMemberships", (Object)this.batchChannelMemberships()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchChannelMemberships": {
                return Optional.ofNullable(clazz.cast(this.batchChannelMemberships()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateChannelMembershipResponse, T> g) {
        return obj -> g.apply((BatchCreateChannelMembershipResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private BatchChannelMemberships batchChannelMemberships;
        private List<BatchCreateChannelMembershipError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateChannelMembershipResponse model) {
            super(model);
            this.batchChannelMemberships(model.batchChannelMemberships);
            this.errors(model.errors);
        }

        public final BatchChannelMemberships.Builder getBatchChannelMemberships() {
            return this.batchChannelMemberships != null ? this.batchChannelMemberships.toBuilder() : null;
        }

        public final void setBatchChannelMemberships(BatchChannelMemberships.BuilderImpl batchChannelMemberships) {
            this.batchChannelMemberships = batchChannelMemberships != null ? batchChannelMemberships.build() : null;
        }

        @Override
        public final Builder batchChannelMemberships(BatchChannelMemberships batchChannelMemberships) {
            this.batchChannelMemberships = batchChannelMemberships;
            return this;
        }

        public final List<BatchCreateChannelMembershipError.Builder> getErrors() {
            List<BatchCreateChannelMembershipError.Builder> result = BatchCreateChannelMembershipErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchCreateChannelMembershipError.BuilderImpl> errors) {
            this.errors = BatchCreateChannelMembershipErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchCreateChannelMembershipError> errors) {
            this.errors = BatchCreateChannelMembershipErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchCreateChannelMembershipError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchCreateChannelMembershipError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchCreateChannelMembershipError)((BatchCreateChannelMembershipError.Builder)BatchCreateChannelMembershipError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateChannelMembershipResponse build() {
            return new BatchCreateChannelMembershipResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateChannelMembershipResponse> {
        public Builder batchChannelMemberships(BatchChannelMemberships var1);

        default public Builder batchChannelMemberships(Consumer<BatchChannelMemberships.Builder> batchChannelMemberships) {
            return this.batchChannelMemberships((BatchChannelMemberships)((BatchChannelMemberships.Builder)BatchChannelMemberships.builder().applyMutation(batchChannelMemberships)).build());
        }

        public Builder errors(Collection<BatchCreateChannelMembershipError> var1);

        public Builder errors(BatchCreateChannelMembershipError ... var1);

        public Builder errors(Consumer<BatchCreateChannelMembershipError.Builder> ... var1);
    }
}

