/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChannelMembershipType;
import software.amazon.awssdk.services.chime.model.Identity;
import software.amazon.awssdk.services.chime.model.MembersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchChannelMemberships
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchChannelMemberships> {
    private static final SdkField<Identity> INVITED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvitedBy").getter(BatchChannelMemberships.getter(BatchChannelMemberships::invitedBy)).setter(BatchChannelMemberships.setter(Builder::invitedBy)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedBy").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(BatchChannelMemberships.getter(BatchChannelMemberships::typeAsString)).setter(BatchChannelMemberships.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<Identity>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(BatchChannelMemberships.getter(BatchChannelMemberships::members)).setter(BatchChannelMemberships.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(BatchChannelMemberships.getter(BatchChannelMemberships::channelArn)).setter(BatchChannelMemberships.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITED_BY_FIELD, TYPE_FIELD, MEMBERS_FIELD, CHANNEL_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Identity invitedBy;
    private final String type;
    private final List<Identity> members;
    private final String channelArn;

    private BatchChannelMemberships(BuilderImpl builder) {
        this.invitedBy = builder.invitedBy;
        this.type = builder.type;
        this.members = builder.members;
        this.channelArn = builder.channelArn;
    }

    public final Identity invitedBy() {
        return this.invitedBy;
    }

    public final ChannelMembershipType type() {
        return ChannelMembershipType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<Identity> members() {
        return this.members;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchChannelMemberships)) {
            return false;
        }
        BatchChannelMemberships other = (BatchChannelMemberships)obj;
        return Objects.equals(this.invitedBy(), other.invitedBy()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && Objects.equals(this.channelArn(), other.channelArn());
    }

    public final String toString() {
        return ToString.builder((String)"BatchChannelMemberships").add("InvitedBy", (Object)this.invitedBy()).add("Type", (Object)this.typeAsString()).add("Members", this.hasMembers() ? this.members() : null).add("ChannelArn", (Object)this.channelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvitedBy": {
                return Optional.ofNullable(clazz.cast(this.invitedBy()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchChannelMemberships, T> g) {
        return obj -> g.apply((BatchChannelMemberships)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Identity invitedBy;
        private String type;
        private List<Identity> members = DefaultSdkAutoConstructList.getInstance();
        private String channelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchChannelMemberships model) {
            this.invitedBy(model.invitedBy);
            this.type(model.type);
            this.members(model.members);
            this.channelArn(model.channelArn);
        }

        public final Identity.Builder getInvitedBy() {
            return this.invitedBy != null ? this.invitedBy.toBuilder() : null;
        }

        public final void setInvitedBy(Identity.BuilderImpl invitedBy) {
            this.invitedBy = invitedBy != null ? invitedBy.build() : null;
        }

        @Override
        public final Builder invitedBy(Identity invitedBy) {
            this.invitedBy = invitedBy;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelMembershipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Identity.Builder> getMembers() {
            List<Identity.Builder> result = MembersCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<Identity.BuilderImpl> members) {
            this.members = MembersCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<Identity> members) {
            this.members = MembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Identity ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<Identity.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (Identity)((Identity.Builder)Identity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public BatchChannelMemberships build() {
            return new BatchChannelMemberships(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchChannelMemberships> {
        public Builder invitedBy(Identity var1);

        default public Builder invitedBy(Consumer<Identity.Builder> invitedBy) {
            return this.invitedBy((Identity)((Identity.Builder)Identity.builder().applyMutation(invitedBy)).build());
        }

        public Builder type(String var1);

        public Builder type(ChannelMembershipType var1);

        public Builder members(Collection<Identity> var1);

        public Builder members(Identity ... var1);

        public Builder members(Consumer<Identity.Builder> ... var1);

        public Builder channelArn(String var1);
    }
}

