/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotAsyncClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.TeamsUserIdentity;

public class ListMicrosoftTeamsUserIdentitiesPublisher
implements SdkPublisher<ListMicrosoftTeamsUserIdentitiesResponse> {
    private final ChatbotAsyncClient client;
    private final ListMicrosoftTeamsUserIdentitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMicrosoftTeamsUserIdentitiesPublisher(ChatbotAsyncClient client, ListMicrosoftTeamsUserIdentitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMicrosoftTeamsUserIdentitiesPublisher(ChatbotAsyncClient client, ListMicrosoftTeamsUserIdentitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMicrosoftTeamsUserIdentitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMicrosoftTeamsUserIdentitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TeamsUserIdentity> teamsUserIdentities() {
        Function<ListMicrosoftTeamsUserIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.teamsUserIdentities() != null) {
                return response.teamsUserIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMicrosoftTeamsUserIdentitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMicrosoftTeamsUserIdentitiesResponseFetcher
    implements AsyncPageFetcher<ListMicrosoftTeamsUserIdentitiesResponse> {
        private ListMicrosoftTeamsUserIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListMicrosoftTeamsUserIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMicrosoftTeamsUserIdentitiesResponse> nextPage(ListMicrosoftTeamsUserIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListMicrosoftTeamsUserIdentitiesPublisher.this.client.listMicrosoftTeamsUserIdentities(ListMicrosoftTeamsUserIdentitiesPublisher.this.firstRequest);
            }
            return ListMicrosoftTeamsUserIdentitiesPublisher.this.client.listMicrosoftTeamsUserIdentities((ListMicrosoftTeamsUserIdentitiesRequest)((Object)ListMicrosoftTeamsUserIdentitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

