/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.SlackChannelConfiguration;

public class DescribeSlackChannelConfigurationsIterable
implements SdkIterable<DescribeSlackChannelConfigurationsResponse> {
    private final ChatbotClient client;
    private final DescribeSlackChannelConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSlackChannelConfigurationsIterable(ChatbotClient client, DescribeSlackChannelConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSlackChannelConfigurationsResponseFetcher();
    }

    public Iterator<DescribeSlackChannelConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SlackChannelConfiguration> slackChannelConfigurations() {
        Function<DescribeSlackChannelConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.slackChannelConfigurations() != null) {
                return response.slackChannelConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSlackChannelConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeSlackChannelConfigurationsResponse> {
        private DescribeSlackChannelConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSlackChannelConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSlackChannelConfigurationsResponse nextPage(DescribeSlackChannelConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSlackChannelConfigurationsIterable.this.client.describeSlackChannelConfigurations(DescribeSlackChannelConfigurationsIterable.this.firstRequest);
            }
            return DescribeSlackChannelConfigurationsIterable.this.client.describeSlackChannelConfigurations((DescribeSlackChannelConfigurationsRequest)((Object)DescribeSlackChannelConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

