/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a parameterized command that can be invoked as an alias or as a notification button in the chat client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomAction implements SdkPojo, Serializable, ToCopyableBuilder<CustomAction.Builder, CustomAction> {
    private static final SdkField<String> CUSTOM_ACTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomActionArn").getter(getter(CustomAction::customActionArn)).setter(setter(Builder::customActionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActionArn").build()).build();

    private static final SdkField<CustomActionDefinition> DEFINITION_FIELD = SdkField
            .<CustomActionDefinition> builder(MarshallingType.SDK_POJO).memberName("Definition")
            .getter(getter(CustomAction::definition)).setter(setter(Builder::definition))
            .constructor(CustomActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()).build();

    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasName").getter(getter(CustomAction::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()).build();

    private static final SdkField<List<CustomActionAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<CustomActionAttachment>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(CustomAction::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomActionAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomActionAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(CustomAction::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTION_ARN_FIELD,
            DEFINITION_FIELD, ALIAS_NAME_FIELD, ATTACHMENTS_FIELD, ACTION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customActionArn;

    private final CustomActionDefinition definition;

    private final String aliasName;

    private final List<CustomActionAttachment> attachments;

    private final String actionName;

    private CustomAction(BuilderImpl builder) {
        this.customActionArn = builder.customActionArn;
        this.definition = builder.definition;
        this.aliasName = builder.aliasName;
        this.attachments = builder.attachments;
        this.actionName = builder.actionName;
    }

    /**
     * <p>
     * The fully defined Amazon Resource Name (ARN) of the custom action.
     * </p>
     * 
     * @return The fully defined Amazon Resource Name (ARN) of the custom action.
     */
    public final String customActionArn() {
        return customActionArn;
    }

    /**
     * <p>
     * The definition of the command to run when invoked an alias or as an action button.
     * </p>
     * 
     * @return The definition of the command to run when invoked an alias or as an action button.
     */
    public final CustomActionDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * The name used to invoke this action in the chat channel. For example, <code>@aws run my-alias</code>.
     * </p>
     * 
     * @return The name used to invoke this action in the chat channel. For example, <code>@aws run my-alias</code>.
     */
    public final String aliasName() {
        return aliasName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines when this custom action button should be attached to a notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return Defines when this custom action button should be attached to a notification.
     */
    public final List<CustomActionAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * The name of the custom action that is included in the ARN.
     * </p>
     * 
     * @return The name of the custom action that is included in the ARN.
     */
    public final String actionName() {
        return actionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customActionArn());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAction)) {
            return false;
        }
        CustomAction other = (CustomAction) obj;
        return Objects.equals(customActionArn(), other.customActionArn()) && Objects.equals(definition(), other.definition())
                && Objects.equals(aliasName(), other.aliasName()) && hasAttachments() == other.hasAttachments()
                && Objects.equals(attachments(), other.attachments()) && Objects.equals(actionName(), other.actionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomAction").add("CustomActionArn", customActionArn()).add("Definition", definition())
                .add("AliasName", aliasName()).add("Attachments", hasAttachments() ? attachments() : null)
                .add("ActionName", actionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomActionArn":
            return Optional.ofNullable(clazz.cast(customActionArn()));
        case "Definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomActionArn", CUSTOM_ACTION_ARN_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("AliasName", ALIAS_NAME_FIELD);
        map.put("Attachments", ATTACHMENTS_FIELD);
        map.put("ActionName", ACTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomAction, T> g) {
        return obj -> g.apply((CustomAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomAction> {
        /**
         * <p>
         * The fully defined Amazon Resource Name (ARN) of the custom action.
         * </p>
         * 
         * @param customActionArn
         *        The fully defined Amazon Resource Name (ARN) of the custom action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActionArn(String customActionArn);

        /**
         * <p>
         * The definition of the command to run when invoked an alias or as an action button.
         * </p>
         * 
         * @param definition
         *        The definition of the command to run when invoked an alias or as an action button.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(CustomActionDefinition definition);

        /**
         * <p>
         * The definition of the command to run when invoked an alias or as an action button.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomActionDefinition.Builder} avoiding
         * the need to create one manually via {@link CustomActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomActionDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #definition(CustomActionDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link CustomActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(CustomActionDefinition)
         */
        default Builder definition(Consumer<CustomActionDefinition.Builder> definition) {
            return definition(CustomActionDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The name used to invoke this action in the chat channel. For example, <code>@aws run my-alias</code>.
         * </p>
         * 
         * @param aliasName
         *        The name used to invoke this action in the chat channel. For example, <code>@aws run my-alias</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * Defines when this custom action button should be attached to a notification.
         * </p>
         * 
         * @param attachments
         *        Defines when this custom action button should be attached to a notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<CustomActionAttachment> attachments);

        /**
         * <p>
         * Defines when this custom action button should be attached to a notification.
         * </p>
         * 
         * @param attachments
         *        Defines when this custom action button should be attached to a notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(CustomActionAttachment... attachments);

        /**
         * <p>
         * Defines when this custom action button should be attached to a notification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chatbot.model.CustomActionAttachment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chatbot.model.CustomActionAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chatbot.model.CustomActionAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<CustomActionAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chatbot.model.CustomActionAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<CustomActionAttachment>)
         */
        Builder attachments(Consumer<CustomActionAttachment.Builder>... attachments);

        /**
         * <p>
         * The name of the custom action that is included in the ARN.
         * </p>
         * 
         * @param actionName
         *        The name of the custom action that is included in the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);
    }

    static final class BuilderImpl implements Builder {
        private String customActionArn;

        private CustomActionDefinition definition;

        private String aliasName;

        private List<CustomActionAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private String actionName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomAction model) {
            customActionArn(model.customActionArn);
            definition(model.definition);
            aliasName(model.aliasName);
            attachments(model.attachments);
            actionName(model.actionName);
        }

        public final String getCustomActionArn() {
            return customActionArn;
        }

        public final void setCustomActionArn(String customActionArn) {
            this.customActionArn = customActionArn;
        }

        @Override
        public final Builder customActionArn(String customActionArn) {
            this.customActionArn = customActionArn;
            return this;
        }

        public final CustomActionDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(CustomActionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(CustomActionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final String getAliasName() {
            return aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final List<CustomActionAttachment.Builder> getAttachments() {
            List<CustomActionAttachment.Builder> result = CustomActionAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<CustomActionAttachment.BuilderImpl> attachments) {
            this.attachments = CustomActionAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<CustomActionAttachment> attachments) {
            this.attachments = CustomActionAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(CustomActionAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<CustomActionAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> CustomActionAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        @Override
        public CustomAction build() {
            return new CustomAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
