/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Microsoft Teams team that is authorized with AWS Chatbot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTeam implements SdkPojo, Serializable, ToCopyableBuilder<ConfiguredTeam.Builder, ConfiguredTeam> {
    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(ConfiguredTeam::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(ConfiguredTeam::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TeamName").getter(getter(ConfiguredTeam::teamName)).setter(setter(Builder::teamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ConfiguredTeam::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(ConfiguredTeam::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TENANT_ID_FIELD,
            TEAM_ID_FIELD, TEAM_NAME_FIELD, STATE_FIELD, STATE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tenantId;

    private final String teamId;

    private final String teamName;

    private final String state;

    private final String stateReason;

    private ConfiguredTeam(BuilderImpl builder) {
        this.tenantId = builder.tenantId;
        this.teamId = builder.teamId;
        this.teamName = builder.teamName;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    /**
     * <p>
     * The ID of the Microsoft Teams tenant.
     * </p>
     * 
     * @return The ID of the Microsoft Teams tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * <p>
     * The ID of the Microsoft Teams authorized with AWS Chatbot.
     * </p>
     * <p>
     * To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot
     * console. Then you can copy and paste the team ID from the console. For more information, see <a
     * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1:
     * Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>.
     * </p>
     * 
     * @return The ID of the Microsoft Teams authorized with AWS Chatbot.</p>
     *         <p>
     *         To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS
     *         Chatbot console. Then you can copy and paste the team ID from the console. For more information, see <a
     *         href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1:
     *         Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>.
     */
    public final String teamId() {
        return teamId;
    }

    /**
     * <p>
     * The name of the Microsoft Teams Team.
     * </p>
     * 
     * @return The name of the Microsoft Teams Team.
     */
    public final String teamName() {
        return teamName;
    }

    /**
     * <p>
     * Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns <code>DISABLED</code> if the
     * organization's AWS Chatbot policy has explicitly denied that configuration. For example, if Amazon Chime is
     * disabled.
     * </p>
     * 
     * @return Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns <code>DISABLED</code> if the
     *         organization's AWS Chatbot policy has explicitly denied that configuration. For example, if Amazon Chime
     *         is disabled.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * Provided if State is <code>DISABLED</code>. Provides context as to why the resource is disabled.
     * </p>
     * 
     * @return Provided if State is <code>DISABLED</code>. Provides context as to why the resource is disabled.
     */
    public final String stateReason() {
        return stateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(teamName());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTeam)) {
            return false;
        }
        ConfiguredTeam other = (ConfiguredTeam) obj;
        return Objects.equals(tenantId(), other.tenantId()) && Objects.equals(teamId(), other.teamId())
                && Objects.equals(teamName(), other.teamName()) && Objects.equals(state(), other.state())
                && Objects.equals(stateReason(), other.stateReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTeam").add("TenantId", tenantId()).add("TeamId", teamId()).add("TeamName", teamName())
                .add("State", state()).add("StateReason", stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "TeamName":
            return Optional.ofNullable(clazz.cast(teamName()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TenantId", TENANT_ID_FIELD);
        map.put("TeamId", TEAM_ID_FIELD);
        map.put("TeamName", TEAM_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTeam, T> g) {
        return obj -> g.apply((ConfiguredTeam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTeam> {
        /**
         * <p>
         * The ID of the Microsoft Teams tenant.
         * </p>
         * 
         * @param tenantId
         *        The ID of the Microsoft Teams tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * <p>
         * The ID of the Microsoft Teams authorized with AWS Chatbot.
         * </p>
         * <p>
         * To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS Chatbot
         * console. Then you can copy and paste the team ID from the console. For more information, see <a
         * href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">Step 1:
         * Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * </p>
         * 
         * @param teamId
         *        The ID of the Microsoft Teams authorized with AWS Chatbot.</p>
         *        <p>
         *        To get the team ID, you must perform the initial authorization flow with Microsoft Teams in the AWS
         *        Chatbot console. Then you can copy and paste the team ID from the console. For more information, see
         *        <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/teams-setup.html#teams-client-setup">
         *        Step 1: Configure a Microsoft Teams client</a> in the <i> AWS Chatbot Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * <p>
         * The name of the Microsoft Teams Team.
         * </p>
         * 
         * @param teamName
         *        The name of the Microsoft Teams Team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamName(String teamName);

        /**
         * <p>
         * Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns <code>DISABLED</code> if the
         * organization's AWS Chatbot policy has explicitly denied that configuration. For example, if Amazon Chime is
         * disabled.
         * </p>
         * 
         * @param state
         *        Either <code>ENABLED</code> or <code>DISABLED</code>. The resource returns <code>DISABLED</code> if
         *        the organization's AWS Chatbot policy has explicitly denied that configuration. For example, if Amazon
         *        Chime is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * Provided if State is <code>DISABLED</code>. Provides context as to why the resource is disabled.
         * </p>
         * 
         * @param stateReason
         *        Provided if State is <code>DISABLED</code>. Provides context as to why the resource is disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);
    }

    static final class BuilderImpl implements Builder {
        private String tenantId;

        private String teamId;

        private String teamName;

        private String state;

        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTeam model) {
            tenantId(model.tenantId);
            teamId(model.teamId);
            teamName(model.teamName);
            state(model.state);
            stateReason(model.stateReason);
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTeamName() {
            return teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        @Override
        public ConfiguredTeam build() {
            return new ConfiguredTeam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
