/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.chatbot.internal.ChatbotServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.chatbot.model.AssociateToConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.AssociateToConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.ChatbotException;
import software.amazon.awssdk.services.chatbot.model.ConflictException;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateCustomActionRequest;
import software.amazon.awssdk.services.chatbot.model.CreateCustomActionResponse;
import software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.CreateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.CreateTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteCustomActionRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteCustomActionResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsConfiguredTeamResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityException;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteMicrosoftTeamsUserIdentityResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackUserIdentityResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationException;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationRequest;
import software.amazon.awssdk.services.chatbot.model.DeleteSlackWorkspaceAuthorizationResponse;
import software.amazon.awssdk.services.chatbot.model.DeleteTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.DeleteTeamsConfiguredTeamException;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesException;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackWorkspacesResponse;
import software.amazon.awssdk.services.chatbot.model.DisassociateFromConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.DisassociateFromConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesException;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesRequest;
import software.amazon.awssdk.services.chatbot.model.GetAccountPreferencesResponse;
import software.amazon.awssdk.services.chatbot.model.GetCustomActionRequest;
import software.amazon.awssdk.services.chatbot.model.GetCustomActionResponse;
import software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.GetMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.GetTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.InternalServiceErrorException;
import software.amazon.awssdk.services.chatbot.model.InvalidParameterException;
import software.amazon.awssdk.services.chatbot.model.InvalidRequestException;
import software.amazon.awssdk.services.chatbot.model.LimitExceededException;
import software.amazon.awssdk.services.chatbot.model.ListAssociationsRequest;
import software.amazon.awssdk.services.chatbot.model.ListAssociationsResponse;
import software.amazon.awssdk.services.chatbot.model.ListCustomActionsRequest;
import software.amazon.awssdk.services.chatbot.model.ListCustomActionsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsException;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsConfiguredTeamsResponse;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesException;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.ListMicrosoftTeamsUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chatbot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chatbot.model.ListTeamsChannelConfigurationsException;
import software.amazon.awssdk.services.chatbot.model.ResourceNotFoundException;
import software.amazon.awssdk.services.chatbot.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chatbot.model.TagResourceRequest;
import software.amazon.awssdk.services.chatbot.model.TagResourceResponse;
import software.amazon.awssdk.services.chatbot.model.TooManyTagsException;
import software.amazon.awssdk.services.chatbot.model.UnauthorizedException;
import software.amazon.awssdk.services.chatbot.model.UntagResourceRequest;
import software.amazon.awssdk.services.chatbot.model.UntagResourceResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesException;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateAccountPreferencesResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationException;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateChimeWebhookConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateCustomActionRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateCustomActionResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateMicrosoftTeamsChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationRequest;
import software.amazon.awssdk.services.chatbot.model.UpdateSlackChannelConfigurationResponse;
import software.amazon.awssdk.services.chatbot.model.UpdateTeamsChannelConfigurationException;
import software.amazon.awssdk.services.chatbot.transform.AssociateToConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.CreateChimeWebhookConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.CreateCustomActionRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.CreateMicrosoftTeamsChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.CreateSlackChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DeleteChimeWebhookConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DeleteCustomActionRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DeleteMicrosoftTeamsChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DeleteMicrosoftTeamsConfiguredTeamRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DeleteMicrosoftTeamsUserIdentityRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DeleteSlackChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DeleteSlackUserIdentityRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DeleteSlackWorkspaceAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DescribeChimeWebhookConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DescribeSlackChannelConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DescribeSlackUserIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DescribeSlackWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.DisassociateFromConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.GetAccountPreferencesRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.GetCustomActionRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.GetMicrosoftTeamsChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.ListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.ListCustomActionsRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.ListMicrosoftTeamsChannelConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.ListMicrosoftTeamsConfiguredTeamsRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.ListMicrosoftTeamsUserIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.UpdateAccountPreferencesRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.UpdateChimeWebhookConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.UpdateCustomActionRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.UpdateMicrosoftTeamsChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chatbot.transform.UpdateSlackChannelConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ChatbotClient}.
 *
 * @see ChatbotClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultChatbotClient implements ChatbotClient {
    private static final Logger log = Logger.loggerFor(DefaultChatbotClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultChatbotClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Links a resource (for example, a custom action) to a channel configuration.
     * </p>
     *
     * @param associateToConfigurationRequest
     * @return Result of the AssociateToConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws UnauthorizedException
     *         The request was rejected because it doesn't have valid credentials for the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.AssociateToConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/AssociateToConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateToConfigurationResponse associateToConfiguration(
            AssociateToConfigurationRequest associateToConfigurationRequest) throws InvalidRequestException,
            InternalServiceErrorException, UnauthorizedException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateToConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateToConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateToConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateToConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateToConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateToConfigurationRequest, AssociateToConfigurationResponse>()
                            .withOperationName("AssociateToConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateToConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateToConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Amazon Chime.
     * </p>
     *
     * @param createChimeWebhookConfigurationRequest
     * @return Result of the CreateChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateChimeWebhookConfigurationResponse createChimeWebhookConfiguration(
            CreateChimeWebhookConfigurationRequest createChimeWebhookConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, ConflictException, LimitExceededException, CreateChimeWebhookConfigurationException,
            AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateChimeWebhookConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateChimeWebhookConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChimeWebhookConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createChimeWebhookConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChimeWebhookConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateChimeWebhookConfigurationRequest, CreateChimeWebhookConfigurationResponse>()
                            .withOperationName("CreateChimeWebhookConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createChimeWebhookConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateChimeWebhookConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom action that can be invoked as an alias or as a button on a notification.
     * </p>
     *
     * @param createCustomActionRequest
     * @return Result of the CreateCustomAction operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws UnauthorizedException
     *         The request was rejected because it doesn't have valid credentials for the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateCustomAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateCustomAction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateCustomActionResponse createCustomAction(CreateCustomActionRequest createCustomActionRequest)
            throws InvalidRequestException, LimitExceededException, ConflictException, InternalServiceErrorException,
            UnauthorizedException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomAction");

            return clientHandler.execute(new ClientExecutionParams<CreateCustomActionRequest, CreateCustomActionResponse>()
                    .withOperationName("CreateCustomAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCustomActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCustomActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an AWS Chatbot configuration for Microsoft Teams.
     * </p>
     *
     * @param createMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the CreateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMicrosoftTeamsChannelConfigurationResponse createMicrosoftTeamsChannelConfiguration(
            CreateMicrosoftTeamsChannelConfigurationRequest createMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ConflictException, LimitExceededException,
            CreateTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMicrosoftTeamsChannelConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, CreateMicrosoftTeamsChannelConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createMicrosoftTeamsChannelConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMicrosoftTeamsChannelConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMicrosoftTeamsChannelConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMicrosoftTeamsChannelConfigurationRequest, CreateMicrosoftTeamsChannelConfigurationResponse>()
                            .withOperationName("CreateMicrosoftTeamsChannelConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(createMicrosoftTeamsChannelConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMicrosoftTeamsChannelConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an AWS Chatbot confugration for Slack.
     * </p>
     *
     * @param createSlackChannelConfigurationRequest
     * @return Result of the CreateSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ConflictException
     *         There was an issue processing your request.
     * @throws LimitExceededException
     *         You have exceeded a service limit for AWS Chatbot.
     * @throws CreateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.CreateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/CreateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSlackChannelConfigurationResponse createSlackChannelConfiguration(
            CreateSlackChannelConfigurationRequest createSlackChannelConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, ConflictException, LimitExceededException, CreateSlackChannelConfigurationException,
            AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSlackChannelConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSlackChannelConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSlackChannelConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createSlackChannelConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSlackChannelConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateSlackChannelConfigurationRequest, CreateSlackChannelConfigurationResponse>()
                            .withOperationName("CreateSlackChannelConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createSlackChannelConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateSlackChannelConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Amazon Chime webhook configuration for AWS Chatbot.
     * </p>
     *
     * @param deleteChimeWebhookConfigurationRequest
     * @return Result of the DeleteChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteChimeWebhookConfigurationResponse deleteChimeWebhookConfiguration(
            DeleteChimeWebhookConfigurationRequest deleteChimeWebhookConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, DeleteChimeWebhookConfigurationException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteChimeWebhookConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteChimeWebhookConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChimeWebhookConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteChimeWebhookConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChimeWebhookConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteChimeWebhookConfigurationRequest, DeleteChimeWebhookConfigurationResponse>()
                            .withOperationName("DeleteChimeWebhookConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteChimeWebhookConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteChimeWebhookConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom action.
     * </p>
     *
     * @param deleteCustomActionRequest
     * @return Result of the DeleteCustomAction operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws UnauthorizedException
     *         The request was rejected because it doesn't have valid credentials for the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteCustomAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteCustomAction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteCustomActionResponse deleteCustomAction(DeleteCustomActionRequest deleteCustomActionRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceErrorException, UnauthorizedException,
            AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomAction");

            return clientHandler.execute(new ClientExecutionParams<DeleteCustomActionRequest, DeleteCustomActionResponse>()
                    .withOperationName("DeleteCustomAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCustomActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCustomActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Microsoft Teams channel configuration for AWS Chatbot
     * </p>
     *
     * @param deleteMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the DeleteMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMicrosoftTeamsChannelConfigurationResponse deleteMicrosoftTeamsChannelConfiguration(
            DeleteMicrosoftTeamsChannelConfigurationRequest deleteMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException,
            DeleteTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMicrosoftTeamsChannelConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeleteMicrosoftTeamsChannelConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteMicrosoftTeamsChannelConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMicrosoftTeamsChannelConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMicrosoftTeamsChannelConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMicrosoftTeamsChannelConfigurationRequest, DeleteMicrosoftTeamsChannelConfigurationResponse>()
                            .withOperationName("DeleteMicrosoftTeamsChannelConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(deleteMicrosoftTeamsChannelConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMicrosoftTeamsChannelConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the Microsoft Teams team authorization allowing for channels to be configured in that Microsoft Teams
     * team. Note that the Microsoft Teams team must have no channels configured to remove it.
     * </p>
     *
     * @param deleteMicrosoftTeamsConfiguredTeamRequest
     * @return Result of the DeleteMicrosoftTeamsConfiguredTeam operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteTeamsConfiguredTeamException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsConfiguredTeam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsConfiguredTeam"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMicrosoftTeamsConfiguredTeamResponse deleteMicrosoftTeamsConfiguredTeam(
            DeleteMicrosoftTeamsConfiguredTeamRequest deleteMicrosoftTeamsConfiguredTeamRequest)
            throws InvalidParameterException, DeleteTeamsConfiguredTeamException, AwsServiceException, SdkClientException,
            ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMicrosoftTeamsConfiguredTeamResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMicrosoftTeamsConfiguredTeamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMicrosoftTeamsConfiguredTeamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMicrosoftTeamsConfiguredTeamRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMicrosoftTeamsConfiguredTeam");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMicrosoftTeamsConfiguredTeamRequest, DeleteMicrosoftTeamsConfiguredTeamResponse>()
                            .withOperationName("DeleteMicrosoftTeamsConfiguredTeam").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMicrosoftTeamsConfiguredTeamRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMicrosoftTeamsConfiguredTeamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Identifes a user level permission for a channel configuration.
     * </p>
     *
     * @param deleteMicrosoftTeamsUserIdentityRequest
     * @return Result of the DeleteMicrosoftTeamsUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws DeleteMicrosoftTeamsUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteMicrosoftTeamsUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteMicrosoftTeamsUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMicrosoftTeamsUserIdentityResponse deleteMicrosoftTeamsUserIdentity(
            DeleteMicrosoftTeamsUserIdentityRequest deleteMicrosoftTeamsUserIdentityRequest) throws InvalidParameterException,
            ResourceNotFoundException, DeleteMicrosoftTeamsUserIdentityException, AwsServiceException, SdkClientException,
            ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMicrosoftTeamsUserIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMicrosoftTeamsUserIdentityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMicrosoftTeamsUserIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMicrosoftTeamsUserIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMicrosoftTeamsUserIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMicrosoftTeamsUserIdentityRequest, DeleteMicrosoftTeamsUserIdentityResponse>()
                            .withOperationName("DeleteMicrosoftTeamsUserIdentity").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMicrosoftTeamsUserIdentityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMicrosoftTeamsUserIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Slack channel configuration for AWS Chatbot
     * </p>
     *
     * @param deleteSlackChannelConfigurationRequest
     * @return Result of the DeleteSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSlackChannelConfigurationResponse deleteSlackChannelConfiguration(
            DeleteSlackChannelConfigurationRequest deleteSlackChannelConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, DeleteSlackChannelConfigurationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSlackChannelConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSlackChannelConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSlackChannelConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteSlackChannelConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlackChannelConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSlackChannelConfigurationRequest, DeleteSlackChannelConfigurationResponse>()
                            .withOperationName("DeleteSlackChannelConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteSlackChannelConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSlackChannelConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user level permission for a Slack channel configuration.
     * </p>
     *
     * @param deleteSlackUserIdentityRequest
     * @return Result of the DeleteSlackUserIdentity operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackUserIdentityException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackUserIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackUserIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSlackUserIdentityResponse deleteSlackUserIdentity(DeleteSlackUserIdentityRequest deleteSlackUserIdentityRequest)
            throws InvalidParameterException, DeleteSlackUserIdentityException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSlackUserIdentityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSlackUserIdentityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSlackUserIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSlackUserIdentityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlackUserIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSlackUserIdentityRequest, DeleteSlackUserIdentityResponse>()
                            .withOperationName("DeleteSlackUserIdentity").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteSlackUserIdentityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSlackUserIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the Slack workspace authorization that allows channels to be configured in that workspace. This requires
     * all configured channels in the workspace to be deleted.
     * </p>
     *
     * @param deleteSlackWorkspaceAuthorizationRequest
     * @return Result of the DeleteSlackWorkspaceAuthorization operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DeleteSlackWorkspaceAuthorizationException
     *         There was an issue deleting your Slack workspace.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DeleteSlackWorkspaceAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DeleteSlackWorkspaceAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSlackWorkspaceAuthorizationResponse deleteSlackWorkspaceAuthorization(
            DeleteSlackWorkspaceAuthorizationRequest deleteSlackWorkspaceAuthorizationRequest) throws InvalidParameterException,
            DeleteSlackWorkspaceAuthorizationException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSlackWorkspaceAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSlackWorkspaceAuthorizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSlackWorkspaceAuthorizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteSlackWorkspaceAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSlackWorkspaceAuthorization");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSlackWorkspaceAuthorizationRequest, DeleteSlackWorkspaceAuthorizationResponse>()
                            .withOperationName("DeleteSlackWorkspaceAuthorization").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteSlackWorkspaceAuthorizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSlackWorkspaceAuthorizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists Amazon Chime webhook configurations optionally filtered by ChatConfigurationArn
     * </p>
     *
     * @param describeChimeWebhookConfigurationsRequest
     * @return Result of the DescribeChimeWebhookConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeChimeWebhookConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeChimeWebhookConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeChimeWebhookConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeChimeWebhookConfigurationsResponse describeChimeWebhookConfigurations(
            DescribeChimeWebhookConfigurationsRequest describeChimeWebhookConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeChimeWebhookConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeChimeWebhookConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeChimeWebhookConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeChimeWebhookConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeChimeWebhookConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChimeWebhookConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeChimeWebhookConfigurationsRequest, DescribeChimeWebhookConfigurationsResponse>()
                            .withOperationName("DescribeChimeWebhookConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeChimeWebhookConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeChimeWebhookConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists Slack channel configurations optionally filtered by ChatConfigurationArn
     * </p>
     *
     * @param describeSlackChannelConfigurationsRequest
     * @return Result of the DescribeSlackChannelConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSlackChannelConfigurationsResponse describeSlackChannelConfigurations(
            DescribeSlackChannelConfigurationsRequest describeSlackChannelConfigurationsRequest)
            throws InvalidParameterException, InvalidRequestException, DescribeSlackChannelConfigurationsException,
            AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSlackChannelConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSlackChannelConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSlackChannelConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeSlackChannelConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlackChannelConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSlackChannelConfigurationsRequest, DescribeSlackChannelConfigurationsResponse>()
                            .withOperationName("DescribeSlackChannelConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeSlackChannelConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSlackChannelConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all Slack user identities with a mapped role.
     * </p>
     *
     * @param describeSlackUserIdentitiesRequest
     * @return Result of the DescribeSlackUserIdentities operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSlackUserIdentitiesResponse describeSlackUserIdentities(
            DescribeSlackUserIdentitiesRequest describeSlackUserIdentitiesRequest) throws InvalidParameterException,
            InvalidRequestException, DescribeSlackUserIdentitiesException, AwsServiceException, SdkClientException,
            ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSlackUserIdentitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSlackUserIdentitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSlackUserIdentitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSlackUserIdentitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlackUserIdentities");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSlackUserIdentitiesRequest, DescribeSlackUserIdentitiesResponse>()
                            .withOperationName("DescribeSlackUserIdentities").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeSlackUserIdentitiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSlackUserIdentitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot.
     * </p>
     *
     * @param describeSlackWorkspacesRequest
     * @return Result of the DescribeSlackWorkspaces operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws DescribeSlackWorkspacesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DescribeSlackWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DescribeSlackWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSlackWorkspacesResponse describeSlackWorkspaces(DescribeSlackWorkspacesRequest describeSlackWorkspacesRequest)
            throws InvalidParameterException, DescribeSlackWorkspacesException, InvalidRequestException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSlackWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSlackWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSlackWorkspacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSlackWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSlackWorkspaces");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSlackWorkspacesRequest, DescribeSlackWorkspacesResponse>()
                            .withOperationName("DescribeSlackWorkspaces").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeSlackWorkspacesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSlackWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Unlink a resource, for example a custom action, from a channel configuration.
     * </p>
     *
     * @param disassociateFromConfigurationRequest
     * @return Result of the DisassociateFromConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws UnauthorizedException
     *         The request was rejected because it doesn't have valid credentials for the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.DisassociateFromConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/DisassociateFromConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateFromConfigurationResponse disassociateFromConfiguration(
            DisassociateFromConfigurationRequest disassociateFromConfigurationRequest) throws InvalidRequestException,
            InternalServiceErrorException, UnauthorizedException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateFromConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateFromConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateFromConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateFromConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFromConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateFromConfigurationRequest, DisassociateFromConfigurationResponse>()
                            .withOperationName("DisassociateFromConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateFromConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateFromConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns AWS Chatbot account preferences.
     * </p>
     *
     * @param getAccountPreferencesRequest
     * @return Result of the GetAccountPreferences operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws GetAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetAccountPreferences" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetAccountPreferencesResponse getAccountPreferences(GetAccountPreferencesRequest getAccountPreferencesRequest)
            throws InvalidRequestException, GetAccountPreferencesException, AwsServiceException, SdkClientException,
            ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccountPreferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAccountPreferencesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountPreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountPreferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountPreferences");

            return clientHandler.execute(new ClientExecutionParams<GetAccountPreferencesRequest, GetAccountPreferencesResponse>()
                    .withOperationName("GetAccountPreferences").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAccountPreferencesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccountPreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a custom action.
     * </p>
     *
     * @param getCustomActionRequest
     * @return Result of the GetCustomAction operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws UnauthorizedException
     *         The request was rejected because it doesn't have valid credentials for the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetCustomAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetCustomAction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCustomActionResponse getCustomAction(GetCustomActionRequest getCustomActionRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceErrorException, UnauthorizedException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCustomActionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCustomActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCustomActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCustomActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCustomAction");

            return clientHandler.execute(new ClientExecutionParams<GetCustomActionRequest, GetCustomActionResponse>()
                    .withOperationName("GetCustomAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCustomActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCustomActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a Microsoft Teams channel configuration in an AWS account.
     * </p>
     *
     * @param getMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the GetMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws GetTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.GetMicrosoftTeamsChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/GetMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMicrosoftTeamsChannelConfigurationResponse getMicrosoftTeamsChannelConfiguration(
            GetMicrosoftTeamsChannelConfigurationRequest getMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, GetTeamsChannelConfigurationException,
            AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMicrosoftTeamsChannelConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetMicrosoftTeamsChannelConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMicrosoftTeamsChannelConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMicrosoftTeamsChannelConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMicrosoftTeamsChannelConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMicrosoftTeamsChannelConfigurationRequest, GetMicrosoftTeamsChannelConfigurationResponse>()
                            .withOperationName("GetMicrosoftTeamsChannelConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(getMicrosoftTeamsChannelConfigurationRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMicrosoftTeamsChannelConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists resources associated with a channel configuration.
     * </p>
     *
     * @param listAssociationsRequest
     * @return Result of the ListAssociations operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAssociationsResponse listAssociations(ListAssociationsRequest listAssociationsRequest) throws AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociations");

            return clientHandler.execute(new ClientExecutionParams<ListAssociationsRequest, ListAssociationsResponse>()
                    .withOperationName("ListAssociations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAssociationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists custom actions defined in this account.
     * </p>
     *
     * @param listCustomActionsRequest
     * @return Result of the ListCustomActions operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws UnauthorizedException
     *         The request was rejected because it doesn't have valid credentials for the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListCustomActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListCustomActions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCustomActionsResponse listCustomActions(ListCustomActionsRequest listCustomActionsRequest)
            throws InvalidRequestException, InternalServiceErrorException, UnauthorizedException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomActionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCustomActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomActions");

            return clientHandler.execute(new ClientExecutionParams<ListCustomActionsRequest, ListCustomActionsResponse>()
                    .withOperationName("ListCustomActions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCustomActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCustomActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all AWS Chatbot Microsoft Teams channel configurations in an AWS account.
     * </p>
     *
     * @param listMicrosoftTeamsChannelConfigurationsRequest
     * @return Result of the ListMicrosoftTeamsChannelConfigurations operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListTeamsChannelConfigurationsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsChannelConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsChannelConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMicrosoftTeamsChannelConfigurationsResponse listMicrosoftTeamsChannelConfigurations(
            ListMicrosoftTeamsChannelConfigurationsRequest listMicrosoftTeamsChannelConfigurationsRequest)
            throws InvalidParameterException, ListTeamsChannelConfigurationsException, InvalidRequestException,
            AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMicrosoftTeamsChannelConfigurationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListMicrosoftTeamsChannelConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMicrosoftTeamsChannelConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMicrosoftTeamsChannelConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMicrosoftTeamsChannelConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMicrosoftTeamsChannelConfigurationsRequest, ListMicrosoftTeamsChannelConfigurationsResponse>()
                            .withOperationName("ListMicrosoftTeamsChannelConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listMicrosoftTeamsChannelConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMicrosoftTeamsChannelConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all authorized Microsoft Teams for an AWS Account
     * </p>
     *
     * @param listMicrosoftTeamsConfiguredTeamsRequest
     * @return Result of the ListMicrosoftTeamsConfiguredTeams operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsConfiguredTeamsException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsConfiguredTeams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsConfiguredTeams"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMicrosoftTeamsConfiguredTeamsResponse listMicrosoftTeamsConfiguredTeams(
            ListMicrosoftTeamsConfiguredTeamsRequest listMicrosoftTeamsConfiguredTeamsRequest) throws InvalidParameterException,
            InvalidRequestException, ListMicrosoftTeamsConfiguredTeamsException, AwsServiceException, SdkClientException,
            ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMicrosoftTeamsConfiguredTeamsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMicrosoftTeamsConfiguredTeamsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMicrosoftTeamsConfiguredTeamsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMicrosoftTeamsConfiguredTeamsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMicrosoftTeamsConfiguredTeams");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMicrosoftTeamsConfiguredTeamsRequest, ListMicrosoftTeamsConfiguredTeamsResponse>()
                            .withOperationName("ListMicrosoftTeamsConfiguredTeams").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listMicrosoftTeamsConfiguredTeamsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMicrosoftTeamsConfiguredTeamsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list all Microsoft Teams user identities with a mapped role.
     * </p>
     *
     * @param listMicrosoftTeamsUserIdentitiesRequest
     * @return Result of the ListMicrosoftTeamsUserIdentities operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ListMicrosoftTeamsUserIdentitiesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListMicrosoftTeamsUserIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListMicrosoftTeamsUserIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMicrosoftTeamsUserIdentitiesResponse listMicrosoftTeamsUserIdentities(
            ListMicrosoftTeamsUserIdentitiesRequest listMicrosoftTeamsUserIdentitiesRequest) throws InvalidParameterException,
            InvalidRequestException, ListMicrosoftTeamsUserIdentitiesException, AwsServiceException, SdkClientException,
            ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMicrosoftTeamsUserIdentitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMicrosoftTeamsUserIdentitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMicrosoftTeamsUserIdentitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMicrosoftTeamsUserIdentitiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMicrosoftTeamsUserIdentities");

            return clientHandler
                    .execute(new ClientExecutionParams<ListMicrosoftTeamsUserIdentitiesRequest, ListMicrosoftTeamsUserIdentitiesResponse>()
                            .withOperationName("ListMicrosoftTeamsUserIdentities").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listMicrosoftTeamsUserIdentitiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMicrosoftTeamsUserIdentitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a
     * user, server, or role.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceUnavailableException, ResourceNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws TooManyTagsException
     *         The supplied list of tags contains too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceUnavailableException,
            ResourceNotFoundException, InternalServiceErrorException, TooManyTagsException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users,
     * servers, roles, and other entities.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceUnavailableException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceUnavailableException,
            ResourceNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates AWS Chatbot account preferences.
     * </p>
     *
     * @param updateAccountPreferencesRequest
     * @return Result of the UpdateAccountPreferences operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws UpdateAccountPreferencesException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateAccountPreferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateAccountPreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccountPreferencesResponse updateAccountPreferences(
            UpdateAccountPreferencesRequest updateAccountPreferencesRequest) throws InvalidParameterException,
            InvalidRequestException, UpdateAccountPreferencesException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccountPreferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAccountPreferencesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccountPreferencesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountPreferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountPreferences");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountPreferencesRequest, UpdateAccountPreferencesResponse>()
                            .withOperationName("UpdateAccountPreferences").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAccountPreferencesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAccountPreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Amazon Chime webhook configuration.
     * </p>
     *
     * @param updateChimeWebhookConfigurationRequest
     * @return Result of the UpdateChimeWebhookConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws UpdateChimeWebhookConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateChimeWebhookConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateChimeWebhookConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateChimeWebhookConfigurationResponse updateChimeWebhookConfiguration(
            UpdateChimeWebhookConfigurationRequest updateChimeWebhookConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, UpdateChimeWebhookConfigurationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateChimeWebhookConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateChimeWebhookConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChimeWebhookConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateChimeWebhookConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChimeWebhookConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateChimeWebhookConfigurationRequest, UpdateChimeWebhookConfigurationResponse>()
                            .withOperationName("UpdateChimeWebhookConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateChimeWebhookConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateChimeWebhookConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a custom action.
     * </p>
     *
     * @param updateCustomActionRequest
     * @return Result of the UpdateCustomAction operation returned by the service.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws InternalServiceErrorException
     *         Unexpected error during processing of request.
     * @throws UnauthorizedException
     *         The request was rejected because it doesn't have valid credentials for the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateCustomAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateCustomAction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateCustomActionResponse updateCustomAction(UpdateCustomActionRequest updateCustomActionRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceErrorException, UnauthorizedException,
            AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCustomActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCustomActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCustomActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCustomActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomAction");

            return clientHandler.execute(new ClientExecutionParams<UpdateCustomActionRequest, UpdateCustomActionResponse>()
                    .withOperationName("UpdateCustomAction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCustomActionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCustomActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Microsoft Teams channel configuration.
     * </p>
     *
     * @param updateMicrosoftTeamsChannelConfigurationRequest
     * @return Result of the UpdateMicrosoftTeamsChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws UpdateTeamsChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateMicrosoftTeamsChannelConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateMicrosoftTeamsChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMicrosoftTeamsChannelConfigurationResponse updateMicrosoftTeamsChannelConfiguration(
            UpdateMicrosoftTeamsChannelConfigurationRequest updateMicrosoftTeamsChannelConfigurationRequest)
            throws InvalidParameterException, InvalidRequestException, ResourceNotFoundException,
            UpdateTeamsChannelConfigurationException, AwsServiceException, SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMicrosoftTeamsChannelConfigurationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateMicrosoftTeamsChannelConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                updateMicrosoftTeamsChannelConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMicrosoftTeamsChannelConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMicrosoftTeamsChannelConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMicrosoftTeamsChannelConfigurationRequest, UpdateMicrosoftTeamsChannelConfigurationResponse>()
                            .withOperationName("UpdateMicrosoftTeamsChannelConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(updateMicrosoftTeamsChannelConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMicrosoftTeamsChannelConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Slack channel configuration.
     * </p>
     *
     * @param updateSlackChannelConfigurationRequest
     * @return Result of the UpdateSlackChannelConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws InvalidRequestException
     *         Your request input doesn't meet the constraints required by AWS Chatbot.
     * @throws ResourceNotFoundException
     *         We were unable to find the resource for your request
     * @throws UpdateSlackChannelConfigurationException
     *         We can’t process your request right now because of a server issue. Try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ChatbotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ChatbotClient.UpdateSlackChannelConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chatbot-2017-10-11/UpdateSlackChannelConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSlackChannelConfigurationResponse updateSlackChannelConfiguration(
            UpdateSlackChannelConfigurationRequest updateSlackChannelConfigurationRequest) throws InvalidParameterException,
            InvalidRequestException, ResourceNotFoundException, UpdateSlackChannelConfigurationException, AwsServiceException,
            SdkClientException, ChatbotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSlackChannelConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSlackChannelConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSlackChannelConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateSlackChannelConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "chatbot");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSlackChannelConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateSlackChannelConfigurationRequest, UpdateSlackChannelConfigurationResponse>()
                            .withOperationName("UpdateSlackChannelConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateSlackChannelConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateSlackChannelConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ChatbotServiceClientConfigurationBuilder serviceConfigBuilder = new ChatbotServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ChatbotException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DescribeChimeWebhookConfigurationsException")
                                .exceptionBuilderSupplier(DescribeChimeWebhookConfigurationsException::builder)
                                .httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GetAccountPreferencesException")
                                .exceptionBuilderSupplier(GetAccountPreferencesException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteSlackWorkspaceAuthorizationFault")
                                .exceptionBuilderSupplier(DeleteSlackWorkspaceAuthorizationException::builder)
                                .httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteMicrosoftTeamsUserIdentityException")
                                .exceptionBuilderSupplier(DeleteMicrosoftTeamsUserIdentityException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteTeamsConfiguredTeamException")
                                .exceptionBuilderSupplier(DeleteTeamsConfiguredTeamException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ListMicrosoftTeamsUserIdentitiesException")
                                .exceptionBuilderSupplier(ListMicrosoftTeamsUserIdentitiesException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CreateChimeWebhookConfigurationException")
                                .exceptionBuilderSupplier(CreateChimeWebhookConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CreateTeamsChannelConfigurationException")
                                .exceptionBuilderSupplier(CreateTeamsChannelConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteChimeWebhookConfigurationException")
                                .exceptionBuilderSupplier(DeleteChimeWebhookConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DescribeSlackWorkspacesException")
                                .exceptionBuilderSupplier(DescribeSlackWorkspacesException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UpdateSlackChannelConfigurationException")
                                .exceptionBuilderSupplier(UpdateSlackChannelConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ListTeamsChannelConfigurationsException")
                                .exceptionBuilderSupplier(ListTeamsChannelConfigurationsException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UpdateChimeWebhookConfigurationException")
                                .exceptionBuilderSupplier(UpdateChimeWebhookConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DescribeSlackChannelConfigurationsException")
                                .exceptionBuilderSupplier(DescribeSlackChannelConfigurationsException::builder)
                                .httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteTeamsChannelConfigurationException")
                                .exceptionBuilderSupplier(DeleteTeamsChannelConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteSlackUserIdentityException")
                                .exceptionBuilderSupplier(DeleteSlackUserIdentityException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UpdateTeamsChannelConfigurationException")
                                .exceptionBuilderSupplier(UpdateTeamsChannelConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UpdateAccountPreferencesException")
                                .exceptionBuilderSupplier(UpdateAccountPreferencesException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CreateSlackChannelConfigurationException")
                                .exceptionBuilderSupplier(CreateSlackChannelConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ListMicrosoftTeamsConfiguredTeamsException")
                                .exceptionBuilderSupplier(ListMicrosoftTeamsConfiguredTeamsException::builder)
                                .httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteSlackChannelConfigurationException")
                                .exceptionBuilderSupplier(DeleteSlackChannelConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceError")
                                .exceptionBuilderSupplier(InternalServiceErrorException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GetTeamsChannelConfigurationException")
                                .exceptionBuilderSupplier(GetTeamsChannelConfigurationException::builder).httpStatusCode(500)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DescribeSlackUserIdentitiesException")
                                .exceptionBuilderSupplier(DescribeSlackUserIdentitiesException::builder).httpStatusCode(500)
                                .build());
    }

    @Override
    public final ChatbotServiceClientConfiguration serviceClientConfiguration() {
        return new ChatbotServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
