/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotAsyncClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackChannelConfigurationsResponse;
import software.amazon.awssdk.services.chatbot.model.SlackChannelConfiguration;

public class DescribeSlackChannelConfigurationsPublisher
implements SdkPublisher<DescribeSlackChannelConfigurationsResponse> {
    private final ChatbotAsyncClient client;
    private final DescribeSlackChannelConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSlackChannelConfigurationsPublisher(ChatbotAsyncClient client, DescribeSlackChannelConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSlackChannelConfigurationsPublisher(ChatbotAsyncClient client, DescribeSlackChannelConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSlackChannelConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSlackChannelConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SlackChannelConfiguration> slackChannelConfigurations() {
        Function<DescribeSlackChannelConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.slackChannelConfigurations() != null) {
                return response.slackChannelConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSlackChannelConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSlackChannelConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeSlackChannelConfigurationsResponse> {
        private DescribeSlackChannelConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSlackChannelConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSlackChannelConfigurationsResponse> nextPage(DescribeSlackChannelConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSlackChannelConfigurationsPublisher.this.client.describeSlackChannelConfigurations(DescribeSlackChannelConfigurationsPublisher.this.firstRequest);
            }
            return DescribeSlackChannelConfigurationsPublisher.this.client.describeSlackChannelConfigurations((DescribeSlackChannelConfigurationsRequest)((Object)DescribeSlackChannelConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

