/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Identifes a user level permission for a channel configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TeamsUserIdentity implements SdkPojo, Serializable,
        ToCopyableBuilder<TeamsUserIdentity.Builder, TeamsUserIdentity> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(TeamsUserIdentity::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChatConfigurationArn").getter(getter(TeamsUserIdentity::chatConfigurationArn))
            .setter(setter(Builder::chatConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build())
            .build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(TeamsUserIdentity::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(TeamsUserIdentity::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> AWS_USER_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsUserIdentity").getter(getter(TeamsUserIdentity::awsUserIdentity))
            .setter(setter(Builder::awsUserIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsUserIdentity").build()).build();

    private static final SdkField<String> TEAMS_CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TeamsChannelId").getter(getter(TeamsUserIdentity::teamsChannelId))
            .setter(setter(Builder::teamsChannelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamsChannelId").build()).build();

    private static final SdkField<String> TEAMS_TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TeamsTenantId").getter(getter(TeamsUserIdentity::teamsTenantId)).setter(setter(Builder::teamsTenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamsTenantId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD,
            CHAT_CONFIGURATION_ARN_FIELD, TEAM_ID_FIELD, USER_ID_FIELD, AWS_USER_IDENTITY_FIELD, TEAMS_CHANNEL_ID_FIELD,
            TEAMS_TENANT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String iamRoleArn;

    private final String chatConfigurationArn;

    private final String teamId;

    private final String userId;

    private final String awsUserIdentity;

    private final String teamsChannelId;

    private final String teamsTenantId;

    private TeamsUserIdentity(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.teamId = builder.teamId;
        this.userId = builder.userId;
        this.awsUserIdentity = builder.awsUserIdentity;
        this.teamsChannelId = builder.teamsChannelId;
        this.teamsTenantId = builder.teamsTenantId;
    }

    /**
     * The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS
     * Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for AWS Chatbot.
     * 
     * @return The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that
     *         AWS Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for
     *         AWS Chatbot.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * The ARN of the MicrosoftTeamsChannelConfiguration associated with the user identity.
     * 
     * @return The ARN of the MicrosoftTeamsChannelConfiguration associated with the user identity.
     */
    public final String chatConfigurationArn() {
        return chatConfigurationArn;
    }

    /**
     * The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial
     * authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from
     * the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot Administrator
     * Guide.
     * 
     * @return The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the
     *         initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste
     *         the team ID from the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the
     *         AWS Chatbot Administrator Guide.
     */
    public final String teamId() {
        return teamId;
    }

    /**
     * Id from Microsoft Teams for user.
     * 
     * @return Id from Microsoft Teams for user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * The AWS user identity ARN used to associate a Microsoft Teams User Identity with an IAM Role.
     * 
     * @return The AWS user identity ARN used to associate a Microsoft Teams User Identity with an IAM Role.
     */
    public final String awsUserIdentity() {
        return awsUserIdentity;
    }

    /**
     * The ID of the Microsoft Teams channel.
     * 
     * @return The ID of the Microsoft Teams channel.
     */
    public final String teamsChannelId() {
        return teamsChannelId;
    }

    /**
     * The ID of the Microsoft Teams tenant.
     * 
     * @return The ID of the Microsoft Teams tenant.
     */
    public final String teamsTenantId() {
        return teamsTenantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(awsUserIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(teamsChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(teamsTenantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeamsUserIdentity)) {
            return false;
        }
        TeamsUserIdentity other = (TeamsUserIdentity) obj;
        return Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(chatConfigurationArn(), other.chatConfigurationArn())
                && Objects.equals(teamId(), other.teamId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(awsUserIdentity(), other.awsUserIdentity())
                && Objects.equals(teamsChannelId(), other.teamsChannelId())
                && Objects.equals(teamsTenantId(), other.teamsTenantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TeamsUserIdentity").add("IamRoleArn", iamRoleArn())
                .add("ChatConfigurationArn", chatConfigurationArn()).add("TeamId", teamId()).add("UserId", userId())
                .add("AwsUserIdentity", awsUserIdentity()).add("TeamsChannelId", teamsChannelId())
                .add("TeamsTenantId", teamsTenantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ChatConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatConfigurationArn()));
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "AwsUserIdentity":
            return Optional.ofNullable(clazz.cast(awsUserIdentity()));
        case "TeamsChannelId":
            return Optional.ofNullable(clazz.cast(teamsChannelId()));
        case "TeamsTenantId":
            return Optional.ofNullable(clazz.cast(teamsTenantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TeamsUserIdentity, T> g) {
        return obj -> g.apply((TeamsUserIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TeamsUserIdentity> {
        /**
         * The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS
         * Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for AWS
         * Chatbot.
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that
         *        AWS Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies
         *        for AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * The ARN of the MicrosoftTeamsChannelConfiguration associated with the user identity.
         * 
         * @param chatConfigurationArn
         *        The ARN of the MicrosoftTeamsChannelConfiguration associated with the user identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatConfigurationArn(String chatConfigurationArn);

        /**
         * The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial
         * authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID
         * from the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot
         * Administrator Guide.
         * 
         * @param teamId
         *        The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the
         *        initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and
         *        paste the team ID from the console. For more details, see steps 1-4 in Get started with Microsoft
         *        Teams in the AWS Chatbot Administrator Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * Id from Microsoft Teams for user.
         * 
         * @param userId
         *        Id from Microsoft Teams for user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * The AWS user identity ARN used to associate a Microsoft Teams User Identity with an IAM Role.
         * 
         * @param awsUserIdentity
         *        The AWS user identity ARN used to associate a Microsoft Teams User Identity with an IAM Role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsUserIdentity(String awsUserIdentity);

        /**
         * The ID of the Microsoft Teams channel.
         * 
         * @param teamsChannelId
         *        The ID of the Microsoft Teams channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamsChannelId(String teamsChannelId);

        /**
         * The ID of the Microsoft Teams tenant.
         * 
         * @param teamsTenantId
         *        The ID of the Microsoft Teams tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamsTenantId(String teamsTenantId);
    }

    static final class BuilderImpl implements Builder {
        private String iamRoleArn;

        private String chatConfigurationArn;

        private String teamId;

        private String userId;

        private String awsUserIdentity;

        private String teamsChannelId;

        private String teamsTenantId;

        private BuilderImpl() {
        }

        private BuilderImpl(TeamsUserIdentity model) {
            iamRoleArn(model.iamRoleArn);
            chatConfigurationArn(model.chatConfigurationArn);
            teamId(model.teamId);
            userId(model.userId);
            awsUserIdentity(model.awsUserIdentity);
            teamsChannelId(model.teamsChannelId);
            teamsTenantId(model.teamsTenantId);
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getChatConfigurationArn() {
            return chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getAwsUserIdentity() {
            return awsUserIdentity;
        }

        public final void setAwsUserIdentity(String awsUserIdentity) {
            this.awsUserIdentity = awsUserIdentity;
        }

        @Override
        public final Builder awsUserIdentity(String awsUserIdentity) {
            this.awsUserIdentity = awsUserIdentity;
            return this;
        }

        public final String getTeamsChannelId() {
            return teamsChannelId;
        }

        public final void setTeamsChannelId(String teamsChannelId) {
            this.teamsChannelId = teamsChannelId;
        }

        @Override
        public final Builder teamsChannelId(String teamsChannelId) {
            this.teamsChannelId = teamsChannelId;
            return this;
        }

        public final String getTeamsTenantId() {
            return teamsTenantId;
        }

        public final void setTeamsTenantId(String teamsTenantId) {
            this.teamsTenantId = teamsTenantId;
        }

        @Override
        public final Builder teamsTenantId(String teamsTenantId) {
            this.teamsTenantId = teamsTenantId;
            return this;
        }

        @Override
        public TeamsUserIdentity build() {
            return new TeamsUserIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
