/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An AWS Chatbot configuration for Microsoft Teams.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TeamsChannelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TeamsChannelConfiguration.Builder, TeamsChannelConfiguration> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(TeamsChannelConfiguration::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(TeamsChannelConfiguration::channelName))
            .setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(TeamsChannelConfiguration::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final SdkField<String> TEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TeamName").getter(getter(TeamsChannelConfiguration::teamName)).setter(setter(Builder::teamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamName").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(TeamsChannelConfiguration::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final SdkField<String> CHAT_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChatConfigurationArn").getter(getter(TeamsChannelConfiguration::chatConfigurationArn))
            .setter(setter(Builder::chatConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatConfigurationArn").build())
            .build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(TeamsChannelConfiguration::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<List<String>> SNS_TOPIC_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnsTopicArns")
            .getter(getter(TeamsChannelConfiguration::snsTopicArns))
            .setter(setter(Builder::snsTopicArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationName").getter(getter(TeamsChannelConfiguration::configurationName))
            .setter(setter(Builder::configurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()).build();

    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingLevel").getter(getter(TeamsChannelConfiguration::loggingLevel))
            .setter(setter(Builder::loggingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()).build();

    private static final SdkField<List<String>> GUARDRAIL_POLICY_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GuardrailPolicyArns")
            .getter(getter(TeamsChannelConfiguration::guardrailPolicyArns))
            .setter(setter(Builder::guardrailPolicyArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GuardrailPolicyArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> USER_AUTHORIZATION_REQUIRED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("UserAuthorizationRequired")
            .getter(getter(TeamsChannelConfiguration::userAuthorizationRequired))
            .setter(setter(Builder::userAuthorizationRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAuthorizationRequired").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            CHANNEL_NAME_FIELD, TEAM_ID_FIELD, TEAM_NAME_FIELD, TENANT_ID_FIELD, CHAT_CONFIGURATION_ARN_FIELD,
            IAM_ROLE_ARN_FIELD, SNS_TOPIC_ARNS_FIELD, CONFIGURATION_NAME_FIELD, LOGGING_LEVEL_FIELD, GUARDRAIL_POLICY_ARNS_FIELD,
            USER_AUTHORIZATION_REQUIRED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelId;

    private final String channelName;

    private final String teamId;

    private final String teamName;

    private final String tenantId;

    private final String chatConfigurationArn;

    private final String iamRoleArn;

    private final List<String> snsTopicArns;

    private final String configurationName;

    private final String loggingLevel;

    private final List<String> guardrailPolicyArns;

    private final Boolean userAuthorizationRequired;

    private TeamsChannelConfiguration(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.channelName = builder.channelName;
        this.teamId = builder.teamId;
        this.teamName = builder.teamName;
        this.tenantId = builder.tenantId;
        this.chatConfigurationArn = builder.chatConfigurationArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.snsTopicArns = builder.snsTopicArns;
        this.configurationName = builder.configurationName;
        this.loggingLevel = builder.loggingLevel;
        this.guardrailPolicyArns = builder.guardrailPolicyArns;
        this.userAuthorizationRequired = builder.userAuthorizationRequired;
    }

    /**
     * The ID of the Microsoft Teams channel.
     * 
     * @return The ID of the Microsoft Teams channel.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * The name of the Microsoft Teams channel.
     * 
     * @return The name of the Microsoft Teams channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial
     * authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from
     * the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot Administrator
     * Guide.
     * 
     * @return The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the
     *         initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste
     *         the team ID from the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the
     *         AWS Chatbot Administrator Guide.
     */
    public final String teamId() {
        return teamId;
    }

    /**
     * The name of the Microsoft Teams Team.
     * 
     * @return The name of the Microsoft Teams Team.
     */
    public final String teamName() {
        return teamName;
    }

    /**
     * The ID of the Microsoft Teams tenant.
     * 
     * @return The ID of the Microsoft Teams tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    /**
     * The ARN of the MicrosoftTeamsChannelConfiguration.
     * 
     * @return The ARN of the MicrosoftTeamsChannelConfiguration.
     */
    public final String chatConfigurationArn() {
        return chatConfigurationArn;
    }

    /**
     * The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS
     * Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for AWS Chatbot.
     * 
     * @return The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that
     *         AWS Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for
     *         AWS Chatbot.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnsTopicArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnsTopicArns() {
        return snsTopicArns != null && !(snsTopicArns instanceof SdkAutoConstructList);
    }

    /**
     * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnsTopicArns} method.
     * </p>
     * 
     * @return The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
     */
    public final List<String> snsTopicArns() {
        return snsTopicArns;
    }

    /**
     * The name of the configuration.
     * 
     * @return The name of the configuration.
     */
    public final String configurationName() {
        return configurationName;
    }

    /**
     * Logging levels include ERROR, INFO, or NONE.
     * 
     * @return Logging levels include ERROR, INFO, or NONE.
     */
    public final String loggingLevel() {
        return loggingLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the GuardrailPolicyArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGuardrailPolicyArns() {
        return guardrailPolicyArns != null && !(guardrailPolicyArns instanceof SdkAutoConstructList);
    }

    /**
     * The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed 'AdministratorAccess' policy
     * is applied by default if this is not set.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGuardrailPolicyArns} method.
     * </p>
     * 
     * @return The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed 'AdministratorAccess'
     *         policy is applied by default if this is not set.
     */
    public final List<String> guardrailPolicyArns() {
        return guardrailPolicyArns;
    }

    /**
     * Enables use of a user role requirement in your chat configuration.
     * 
     * @return Enables use of a user role requirement in your chat configuration.
     */
    public final Boolean userAuthorizationRequired() {
        return userAuthorizationRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        hashCode = 31 * hashCode + Objects.hashCode(teamName());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        hashCode = 31 * hashCode + Objects.hashCode(chatConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnsTopicArns() ? snsTopicArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(hasGuardrailPolicyArns() ? guardrailPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userAuthorizationRequired());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeamsChannelConfiguration)) {
            return false;
        }
        TeamsChannelConfiguration other = (TeamsChannelConfiguration) obj;
        return Objects.equals(channelId(), other.channelId()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(teamId(), other.teamId()) && Objects.equals(teamName(), other.teamName())
                && Objects.equals(tenantId(), other.tenantId())
                && Objects.equals(chatConfigurationArn(), other.chatConfigurationArn())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && hasSnsTopicArns() == other.hasSnsTopicArns()
                && Objects.equals(snsTopicArns(), other.snsTopicArns())
                && Objects.equals(configurationName(), other.configurationName())
                && Objects.equals(loggingLevel(), other.loggingLevel())
                && hasGuardrailPolicyArns() == other.hasGuardrailPolicyArns()
                && Objects.equals(guardrailPolicyArns(), other.guardrailPolicyArns())
                && Objects.equals(userAuthorizationRequired(), other.userAuthorizationRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TeamsChannelConfiguration").add("ChannelId", channelId()).add("ChannelName", channelName())
                .add("TeamId", teamId()).add("TeamName", teamName()).add("TenantId", tenantId())
                .add("ChatConfigurationArn", chatConfigurationArn()).add("IamRoleArn", iamRoleArn())
                .add("SnsTopicArns", hasSnsTopicArns() ? snsTopicArns() : null).add("ConfigurationName", configurationName())
                .add("LoggingLevel", loggingLevel())
                .add("GuardrailPolicyArns", hasGuardrailPolicyArns() ? guardrailPolicyArns() : null)
                .add("UserAuthorizationRequired", userAuthorizationRequired()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        case "TeamName":
            return Optional.ofNullable(clazz.cast(teamName()));
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        case "ChatConfigurationArn":
            return Optional.ofNullable(clazz.cast(chatConfigurationArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "SnsTopicArns":
            return Optional.ofNullable(clazz.cast(snsTopicArns()));
        case "ConfigurationName":
            return Optional.ofNullable(clazz.cast(configurationName()));
        case "LoggingLevel":
            return Optional.ofNullable(clazz.cast(loggingLevel()));
        case "GuardrailPolicyArns":
            return Optional.ofNullable(clazz.cast(guardrailPolicyArns()));
        case "UserAuthorizationRequired":
            return Optional.ofNullable(clazz.cast(userAuthorizationRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TeamsChannelConfiguration, T> g) {
        return obj -> g.apply((TeamsChannelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TeamsChannelConfiguration> {
        /**
         * The ID of the Microsoft Teams channel.
         * 
         * @param channelId
         *        The ID of the Microsoft Teams channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * The name of the Microsoft Teams channel.
         * 
         * @param channelName
         *        The name of the Microsoft Teams channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial
         * authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID
         * from the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot
         * Administrator Guide.
         * 
         * @param teamId
         *        The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the
         *        initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and
         *        paste the team ID from the console. For more details, see steps 1-4 in Get started with Microsoft
         *        Teams in the AWS Chatbot Administrator Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        /**
         * The name of the Microsoft Teams Team.
         * 
         * @param teamName
         *        The name of the Microsoft Teams Team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamName(String teamName);

        /**
         * The ID of the Microsoft Teams tenant.
         * 
         * @param tenantId
         *        The ID of the Microsoft Teams tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);

        /**
         * The ARN of the MicrosoftTeamsChannelConfiguration.
         * 
         * @param chatConfigurationArn
         *        The ARN of the MicrosoftTeamsChannelConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chatConfigurationArn(String chatConfigurationArn);

        /**
         * The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that AWS
         * Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies for AWS
         * Chatbot.
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role that defines the permissions for AWS Chatbot. This is a user-defined role that
         *        AWS Chatbot will assume. This is not the service-linked role. For more information, see IAM Policies
         *        for AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * 
         * @param snsTopicArns
         *        The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArns(Collection<String> snsTopicArns);

        /**
         * The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * 
         * @param snsTopicArns
         *        The ARNs of the SNS topics that deliver notifications to AWS Chatbot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArns(String... snsTopicArns);

        /**
         * The name of the configuration.
         * 
         * @param configurationName
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationName(String configurationName);

        /**
         * Logging levels include ERROR, INFO, or NONE.
         * 
         * @param loggingLevel
         *        Logging levels include ERROR, INFO, or NONE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingLevel(String loggingLevel);

        /**
         * The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed 'AdministratorAccess'
         * policy is applied by default if this is not set.
         * 
         * @param guardrailPolicyArns
         *        The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed
         *        'AdministratorAccess' policy is applied by default if this is not set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailPolicyArns(Collection<String> guardrailPolicyArns);

        /**
         * The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed 'AdministratorAccess'
         * policy is applied by default if this is not set.
         * 
         * @param guardrailPolicyArns
         *        The list of IAM policy ARNs that are applied as channel guardrails. The AWS managed
         *        'AdministratorAccess' policy is applied by default if this is not set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailPolicyArns(String... guardrailPolicyArns);

        /**
         * Enables use of a user role requirement in your chat configuration.
         * 
         * @param userAuthorizationRequired
         *        Enables use of a user role requirement in your chat configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAuthorizationRequired(Boolean userAuthorizationRequired);
    }

    static final class BuilderImpl implements Builder {
        private String channelId;

        private String channelName;

        private String teamId;

        private String teamName;

        private String tenantId;

        private String chatConfigurationArn;

        private String iamRoleArn;

        private List<String> snsTopicArns = DefaultSdkAutoConstructList.getInstance();

        private String configurationName;

        private String loggingLevel;

        private List<String> guardrailPolicyArns = DefaultSdkAutoConstructList.getInstance();

        private Boolean userAuthorizationRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(TeamsChannelConfiguration model) {
            channelId(model.channelId);
            channelName(model.channelName);
            teamId(model.teamId);
            teamName(model.teamName);
            tenantId(model.tenantId);
            chatConfigurationArn(model.chatConfigurationArn);
            iamRoleArn(model.iamRoleArn);
            snsTopicArns(model.snsTopicArns);
            configurationName(model.configurationName);
            loggingLevel(model.loggingLevel);
            guardrailPolicyArns(model.guardrailPolicyArns);
            userAuthorizationRequired(model.userAuthorizationRequired);
        }

        public final String getChannelId() {
            return channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final String getTeamName() {
            return teamName;
        }

        public final void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @Override
        public final Builder teamName(String teamName) {
            this.teamName = teamName;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final String getChatConfigurationArn() {
            return chatConfigurationArn;
        }

        public final void setChatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
        }

        @Override
        public final Builder chatConfigurationArn(String chatConfigurationArn) {
            this.chatConfigurationArn = chatConfigurationArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Collection<String> getSnsTopicArns() {
            if (snsTopicArns instanceof SdkAutoConstructList) {
                return null;
            }
            return snsTopicArns;
        }

        public final void setSnsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
        }

        @Override
        public final Builder snsTopicArns(Collection<String> snsTopicArns) {
            this.snsTopicArns = SnsTopicArnListCopier.copy(snsTopicArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snsTopicArns(String... snsTopicArns) {
            snsTopicArns(Arrays.asList(snsTopicArns));
            return this;
        }

        public final String getConfigurationName() {
            return configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getLoggingLevel() {
            return loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final Collection<String> getGuardrailPolicyArns() {
            if (guardrailPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return guardrailPolicyArns;
        }

        public final void setGuardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
        }

        @Override
        public final Builder guardrailPolicyArns(Collection<String> guardrailPolicyArns) {
            this.guardrailPolicyArns = GuardrailPolicyArnListCopier.copy(guardrailPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailPolicyArns(String... guardrailPolicyArns) {
            guardrailPolicyArns(Arrays.asList(guardrailPolicyArns));
            return this;
        }

        public final Boolean getUserAuthorizationRequired() {
            return userAuthorizationRequired;
        }

        public final void setUserAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
        }

        @Override
        public final Builder userAuthorizationRequired(Boolean userAuthorizationRequired) {
            this.userAuthorizationRequired = userAuthorizationRequired;
            return this;
        }

        @Override
        public TeamsChannelConfiguration build() {
            return new TeamsChannelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
