/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMicrosoftTeamsChannelConfigurationsRequest extends ChatbotRequest implements
        ToCopyableBuilder<ListMicrosoftTeamsChannelConfigurationsRequest.Builder, ListMicrosoftTeamsChannelConfigurationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListMicrosoftTeamsChannelConfigurationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMicrosoftTeamsChannelConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> TEAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TeamId")
            .getter(getter(ListMicrosoftTeamsChannelConfigurationsRequest::teamId)).setter(setter(Builder::teamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TeamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, TEAM_ID_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String teamId;

    private ListMicrosoftTeamsChannelConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.teamId = builder.teamId;
    }

    /**
     * The maximum number of results to include in the response. If more results exist than the specified MaxResults
     * value, a token is included in the response so that the remaining results can be retrieved.
     * 
     * @return The maximum number of results to include in the response. If more results exist than the specified
     *         MaxResults value, a token is included in the response so that the remaining results can be retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * MaxResults.
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial
     * authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID from
     * the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot Administrator
     * Guide.
     * 
     * @return The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the
     *         initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste
     *         the team ID from the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the
     *         AWS Chatbot Administrator Guide.
     */
    public final String teamId() {
        return teamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(teamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMicrosoftTeamsChannelConfigurationsRequest)) {
            return false;
        }
        ListMicrosoftTeamsChannelConfigurationsRequest other = (ListMicrosoftTeamsChannelConfigurationsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(teamId(), other.teamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMicrosoftTeamsChannelConfigurationsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("TeamId", teamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TeamId":
            return Optional.ofNullable(clazz.cast(teamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMicrosoftTeamsChannelConfigurationsRequest, T> g) {
        return obj -> g.apply((ListMicrosoftTeamsChannelConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChatbotRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMicrosoftTeamsChannelConfigurationsRequest> {
        /**
         * The maximum number of results to include in the response. If more results exist than the specified MaxResults
         * value, a token is included in the response so that the remaining results can be retrieved.
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the specified
         *        MaxResults value, a token is included in the response so that the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by MaxResults.
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the initial
         * authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and paste the team ID
         * from the console. For more details, see steps 1-4 in Get started with Microsoft Teams in the AWS Chatbot
         * Administrator Guide.
         * 
         * @param teamId
         *        The ID of the Microsoft Team authorized with AWS Chatbot. To get the team ID, you must perform the
         *        initial authorization flow with Microsoft Teams in the AWS Chatbot console. Then you can copy and
         *        paste the team ID from the console. For more details, see steps 1-4 in Get started with Microsoft
         *        Teams in the AWS Chatbot Administrator Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teamId(String teamId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChatbotRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String teamId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMicrosoftTeamsChannelConfigurationsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            teamId(model.teamId);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTeamId() {
            return teamId;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMicrosoftTeamsChannelConfigurationsRequest build() {
            return new ListMicrosoftTeamsChannelConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
