/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Request of UpdateNotification
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateNotificationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateNotificationRequest.Builder, UpdateNotificationRequest> {
    private final String accountId;

    private final String budgetName;

    private final Notification oldNotification;

    private final Notification newNotification;

    private UpdateNotificationRequest(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.budgetName = builder.budgetName;
        this.oldNotification = builder.oldNotification;
        this.newNotification = builder.newNotification;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the BudgetName property for this object.
     * 
     * @return The value of the BudgetName property for this object.
     */
    public String budgetName() {
        return budgetName;
    }

    /**
     * Returns the value of the OldNotification property for this object.
     * 
     * @return The value of the OldNotification property for this object.
     */
    public Notification oldNotification() {
        return oldNotification;
    }

    /**
     * Returns the value of the NewNotification property for this object.
     * 
     * @return The value of the NewNotification property for this object.
     */
    public Notification newNotification() {
        return newNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((accountId() == null) ? 0 : accountId().hashCode());
        hashCode = 31 * hashCode + ((budgetName() == null) ? 0 : budgetName().hashCode());
        hashCode = 31 * hashCode + ((oldNotification() == null) ? 0 : oldNotification().hashCode());
        hashCode = 31 * hashCode + ((newNotification() == null) ? 0 : newNotification().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationRequest)) {
            return false;
        }
        UpdateNotificationRequest other = (UpdateNotificationRequest) obj;
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.budgetName() == null ^ this.budgetName() == null) {
            return false;
        }
        if (other.budgetName() != null && !other.budgetName().equals(this.budgetName())) {
            return false;
        }
        if (other.oldNotification() == null ^ this.oldNotification() == null) {
            return false;
        }
        if (other.oldNotification() != null && !other.oldNotification().equals(this.oldNotification())) {
            return false;
        }
        if (other.newNotification() == null ^ this.newNotification() == null) {
            return false;
        }
        if (other.newNotification() != null && !other.newNotification().equals(this.newNotification())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (accountId() != null) {
            sb.append("AccountId: ").append(accountId()).append(",");
        }
        if (budgetName() != null) {
            sb.append("BudgetName: ").append(budgetName()).append(",");
        }
        if (oldNotification() != null) {
            sb.append("OldNotification: ").append(oldNotification()).append(",");
        }
        if (newNotification() != null) {
            sb.append("NewNotification: ").append(newNotification()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateNotificationRequest> {
        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the BudgetName property for this object.
         *
         * @param budgetName
         *        The new value for the BudgetName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder budgetName(String budgetName);

        /**
         * Sets the value of the OldNotification property for this object.
         *
         * @param oldNotification
         *        The new value for the OldNotification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oldNotification(Notification oldNotification);

        /**
         * Sets the value of the NewNotification property for this object.
         *
         * @param newNotification
         *        The new value for the NewNotification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newNotification(Notification newNotification);
    }

    private static final class BuilderImpl implements Builder {
        private String accountId;

        private String budgetName;

        private Notification oldNotification;

        private Notification newNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationRequest model) {
            setAccountId(model.accountId);
            setBudgetName(model.budgetName);
            setOldNotification(model.oldNotification);
            setNewNotification(model.newNotification);
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getBudgetName() {
            return budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        public final Notification getOldNotification() {
            return oldNotification;
        }

        @Override
        public final Builder oldNotification(Notification oldNotification) {
            this.oldNotification = oldNotification;
            return this;
        }

        public final void setOldNotification(Notification oldNotification) {
            this.oldNotification = oldNotification;
        }

        public final Notification getNewNotification() {
            return newNotification;
        }

        @Override
        public final Builder newNotification(Notification newNotification) {
            this.newNotification = newNotification;
            return this;
        }

        public final void setNewNotification(Notification newNotification) {
            this.newNotification = newNotification;
        }

        @Override
        public UpdateNotificationRequest build() {
            return new UpdateNotificationRequest(this);
        }
    }
}
