/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.TimePeriodMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A time period indicated the start date and end date of a budget.
 */
@Generated("software.amazon.awssdk:codegen")
public class TimePeriod implements StructuredPojo, ToCopyableBuilder<TimePeriod.Builder, TimePeriod> {
    private final Instant start;

    private final Instant end;

    private TimePeriod(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * Returns the value of the Start property for this object.
     * 
     * @return The value of the Start property for this object.
     */
    public Instant start() {
        return start;
    }

    /**
     * Returns the value of the End property for this object.
     * 
     * @return The value of the End property for this object.
     */
    public Instant end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((start() == null) ? 0 : start().hashCode());
        hashCode = 31 * hashCode + ((end() == null) ? 0 : end().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimePeriod)) {
            return false;
        }
        TimePeriod other = (TimePeriod) obj;
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (start() != null) {
            sb.append("Start: ").append(start()).append(",");
        }
        if (end() != null) {
            sb.append("End: ").append(end()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimePeriodMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TimePeriod> {
        /**
         * Sets the value of the Start property for this object.
         *
         * @param start
         *        The new value for the Start property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * Sets the value of the End property for this object.
         *
         * @param end
         *        The new value for the End property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);
    }

    private static final class BuilderImpl implements Builder {
        private Instant start;

        private Instant end;

        private BuilderImpl() {
        }

        private BuilderImpl(TimePeriod model) {
            setStart(model.start);
            setEnd(model.end);
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final Instant getEnd() {
            return end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public TimePeriod build() {
            return new TimePeriod(this);
        }
    }
}
