/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.transform.NotificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Notification model. Each budget may contain multiple notifications with different settings.
 */
@Generated("software.amazon.awssdk:codegen")
public class Notification implements StructuredPojo, ToCopyableBuilder<Notification.Builder, Notification> {
    private final String notificationType;

    private final String comparisonOperator;

    private final Double threshold;

    private Notification(BuilderImpl builder) {
        this.notificationType = builder.notificationType;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
    }

    /**
     * Returns the value of the NotificationType property for this object.
     * 
     * @return The value of the NotificationType property for this object.
     * @see NotificationType
     */
    public String notificationType() {
        return notificationType;
    }

    /**
     * Returns the value of the ComparisonOperator property for this object.
     * 
     * @return The value of the ComparisonOperator property for this object.
     * @see ComparisonOperator
     */
    public String comparisonOperator() {
        return comparisonOperator;
    }

    /**
     * Returns the value of the Threshold property for this object.
     * 
     * @return The value of the Threshold property for this object.
     */
    public Double threshold() {
        return threshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((notificationType() == null) ? 0 : notificationType().hashCode());
        hashCode = 31 * hashCode + ((comparisonOperator() == null) ? 0 : comparisonOperator().hashCode());
        hashCode = 31 * hashCode + ((threshold() == null) ? 0 : threshold().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification) obj;
        if (other.notificationType() == null ^ this.notificationType() == null) {
            return false;
        }
        if (other.notificationType() != null && !other.notificationType().equals(this.notificationType())) {
            return false;
        }
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        if (other.comparisonOperator() != null && !other.comparisonOperator().equals(this.comparisonOperator())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        if (other.threshold() != null && !other.threshold().equals(this.threshold())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (notificationType() != null) {
            sb.append("NotificationType: ").append(notificationType()).append(",");
        }
        if (comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(comparisonOperator()).append(",");
        }
        if (threshold() != null) {
            sb.append("Threshold: ").append(threshold()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Notification> {
        /**
         * Sets the value of the NotificationType property for this object.
         *
         * @param notificationType
         *        The new value for the NotificationType property for this object.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(String notificationType);

        /**
         * Sets the value of the NotificationType property for this object.
         *
         * @param notificationType
         *        The new value for the NotificationType property for this object.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder notificationType(NotificationType notificationType);

        /**
         * Sets the value of the ComparisonOperator property for this object.
         *
         * @param comparisonOperator
         *        The new value for the ComparisonOperator property for this object.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * Sets the value of the ComparisonOperator property for this object.
         *
         * @param comparisonOperator
         *        The new value for the ComparisonOperator property for this object.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * Sets the value of the Threshold property for this object.
         *
         * @param threshold
         *        The new value for the Threshold property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);
    }

    private static final class BuilderImpl implements Builder {
        private String notificationType;

        private String comparisonOperator;

        private Double threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            setNotificationType(model.notificationType);
            setComparisonOperator(model.comparisonOperator);
            setThreshold(model.threshold);
        }

        public final String getNotificationType() {
            return notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getThreshold() {
            return threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public Notification build() {
            return new Notification(this);
        }
    }
}
