/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.Subscriber;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubscriberMarshaller {
    private static final MarshallingInfo<String> SUBSCRIPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionType").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").isBinary(false).build();
    private static final SubscriberMarshaller INSTANCE = new SubscriberMarshaller();

    private SubscriberMarshaller() {
    }

    public static SubscriberMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Subscriber subscriber, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)subscriber, (String)"subscriber");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)subscriber.subscriptionTypeAsString(), SUBSCRIPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)subscriber.address(), ADDRESS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

