/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.CostTypes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CostTypesMarshaller {
    private static final MarshallingInfo<Boolean> INCLUDETAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeTax").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INCLUDESUBSCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeSubscription").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USEBLENDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseBlended").isBinary(false).build();
    private static final CostTypesMarshaller INSTANCE = new CostTypesMarshaller();

    private CostTypesMarshaller() {
    }

    public static CostTypesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CostTypes costTypes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)costTypes, (String)"costTypes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)costTypes.includeTax(), INCLUDETAX_BINDING);
            protocolMarshaller.marshall((Object)costTypes.includeSubscription(), INCLUDESUBSCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)costTypes.useBlended(), USEBLENDED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

