/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.services.budgets.model.BudgetsRequest;
import software.amazon.awssdk.services.budgets.model.NotificationWithSubscribers;
import software.amazon.awssdk.services.budgets.model.NotificationWithSubscribersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBudgetRequest
extends BudgetsRequest
implements ToCopyableBuilder<Builder, CreateBudgetRequest> {
    private final String accountId;
    private final Budget budget;
    private final List<NotificationWithSubscribers> notificationsWithSubscribers;

    private CreateBudgetRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.budget = builder.budget;
        this.notificationsWithSubscribers = builder.notificationsWithSubscribers;
    }

    public String accountId() {
        return this.accountId;
    }

    public Budget budget() {
        return this.budget;
    }

    public List<NotificationWithSubscribers> notificationsWithSubscribers() {
        return this.notificationsWithSubscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.budget());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationsWithSubscribers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBudgetRequest)) {
            return false;
        }
        CreateBudgetRequest other = (CreateBudgetRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.budget(), other.budget()) && Objects.equals(this.notificationsWithSubscribers(), other.notificationsWithSubscribers());
    }

    public String toString() {
        return ToString.builder((String)"CreateBudgetRequest").add("AccountId", (Object)this.accountId()).add("Budget", (Object)this.budget()).add("NotificationsWithSubscribers", this.notificationsWithSubscribers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "Budget": {
                return Optional.ofNullable(clazz.cast(this.budget()));
            }
            case "NotificationsWithSubscribers": {
                return Optional.ofNullable(clazz.cast(this.notificationsWithSubscribers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BudgetsRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private Budget budget;
        private List<NotificationWithSubscribers> notificationsWithSubscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBudgetRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.budget(model.budget);
            this.notificationsWithSubscribers(model.notificationsWithSubscribers);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Budget.Builder getBudget() {
            return this.budget != null ? this.budget.toBuilder() : null;
        }

        @Override
        public final Builder budget(Budget budget) {
            this.budget = budget;
            return this;
        }

        public final void setBudget(Budget.BuilderImpl budget) {
            this.budget = budget != null ? budget.build() : null;
        }

        public final Collection<NotificationWithSubscribers.Builder> getNotificationsWithSubscribers() {
            return this.notificationsWithSubscribers != null ? (Collection)this.notificationsWithSubscribers.stream().map(NotificationWithSubscribers::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notificationsWithSubscribers(Collection<NotificationWithSubscribers> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = NotificationWithSubscribersListCopier.copy(notificationsWithSubscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationsWithSubscribers(NotificationWithSubscribers ... notificationsWithSubscribers) {
            this.notificationsWithSubscribers(Arrays.asList(notificationsWithSubscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationsWithSubscribers(Consumer<NotificationWithSubscribers.Builder> ... notificationsWithSubscribers) {
            this.notificationsWithSubscribers(Stream.of(notificationsWithSubscribers).map(c -> (NotificationWithSubscribers)((NotificationWithSubscribers.Builder)NotificationWithSubscribers.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotificationsWithSubscribers(Collection<NotificationWithSubscribers.BuilderImpl> notificationsWithSubscribers) {
            this.notificationsWithSubscribers = NotificationWithSubscribersListCopier.copyFromBuilder(notificationsWithSubscribers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBudgetRequest build() {
            return new CreateBudgetRequest(this);
        }
    }

    public static interface Builder
    extends BudgetsRequest.Builder,
    CopyableBuilder<Builder, CreateBudgetRequest> {
        public Builder accountId(String var1);

        public Builder budget(Budget var1);

        default public Builder budget(Consumer<Budget.Builder> budget) {
            return this.budget((Budget)((Budget.Builder)Budget.builder().applyMutation(budget)).build());
        }

        public Builder notificationsWithSubscribers(Collection<NotificationWithSubscribers> var1);

        public Builder notificationsWithSubscribers(NotificationWithSubscribers ... var1);

        public Builder notificationsWithSubscribers(Consumer<NotificationWithSubscribers.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

