/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UpdateSubscriberRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UpdateSubscriberRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").isBinary(false).build();

    private static final MarshallingInfo<String> BUDGETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> OLDSUBSCRIBER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OldSubscriber")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NEWSUBSCRIBER_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NewSubscriber")
            .isBinary(false).build();

    private static final UpdateSubscriberRequestModelMarshaller INSTANCE = new UpdateSubscriberRequestModelMarshaller();

    private UpdateSubscriberRequestModelMarshaller() {
    }

    public static UpdateSubscriberRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UpdateSubscriberRequest updateSubscriberRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(updateSubscriberRequest, "updateSubscriberRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(updateSubscriberRequest.accountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(updateSubscriberRequest.budgetName(), BUDGETNAME_BINDING);
            protocolMarshaller.marshall(updateSubscriberRequest.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall(updateSubscriberRequest.oldSubscriber(), OLDSUBSCRIBER_BINDING);
            protocolMarshaller.marshall(updateSubscriberRequest.newSubscriber(), NEWSUBSCRIBER_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
