/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.transform;

import java.math.BigDecimal;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.budgets.model.Spend;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Spend} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SpendMarshaller {
    private static final MarshallingInfo<BigDecimal> AMOUNT_BINDING = MarshallingInfo.builder(MarshallingType.BIG_DECIMAL)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Amount").isBinary(false).build();

    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").isBinary(false).build();

    private static final SpendMarshaller INSTANCE = new SpendMarshaller();

    private SpendMarshaller() {
    }

    public static SpendMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Spend spend, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(spend, "spend");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(spend.amount(), AMOUNT_BINDING);
            protocolMarshaller.marshall(spend.unit(), UNIT_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
