/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.budgets.model.Budget;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Budget} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class BudgetMarshaller {
    private static final MarshallingInfo<String> BUDGETNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> BUDGETLIMIT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetLimit")
            .isBinary(false).build();

    private static final MarshallingInfo<Map> COSTFILTERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CostFilters").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> COSTTYPES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CostTypes").isBinary(false).build();

    private static final MarshallingInfo<String> TIMEUNIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeUnit").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> TIMEPERIOD_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimePeriod").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CALCULATEDSPEND_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CalculatedSpend").isBinary(false).build();

    private static final MarshallingInfo<String> BUDGETTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BudgetType").isBinary(false).build();

    private static final BudgetMarshaller INSTANCE = new BudgetMarshaller();

    private BudgetMarshaller() {
    }

    public static BudgetMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Budget budget, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(budget, "budget");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(budget.budgetName(), BUDGETNAME_BINDING);
            protocolMarshaller.marshall(budget.budgetLimit(), BUDGETLIMIT_BINDING);
            protocolMarshaller.marshall(budget.costFilters(), COSTFILTERS_BINDING);
            protocolMarshaller.marshall(budget.costTypes(), COSTTYPES_BINDING);
            protocolMarshaller.marshall(budget.timeUnitAsString(), TIMEUNIT_BINDING);
            protocolMarshaller.marshall(budget.timePeriod(), TIMEPERIOD_BINDING);
            protocolMarshaller.marshall(budget.calculatedSpend(), CALCULATEDSPEND_BINDING);
            protocolMarshaller.marshall(budget.budgetTypeAsString(), BUDGETTYPE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
