/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.budgets;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.budgets.model.CreateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.CreateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.CreateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.CreateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.CreateSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DeleteBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DeleteNotificationResponse;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.DeleteSubscriberResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsRequest;
import software.amazon.awssdk.services.budgets.model.DescribeBudgetsResponse;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationRequest;
import software.amazon.awssdk.services.budgets.model.DescribeSubscribersForNotificationResponse;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetRequest;
import software.amazon.awssdk.services.budgets.model.UpdateBudgetResponse;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationRequest;
import software.amazon.awssdk.services.budgets.model.UpdateNotificationResponse;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberRequest;
import software.amazon.awssdk.services.budgets.model.UpdateSubscriberResponse;

/**
 * Service client for accessing AWSBudgets asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * All public APIs for AWS Budgets
 */
@Generated("software.amazon.awssdk:codegen")
public interface BudgetsAsyncClient extends SdkClient {
    String SERVICE_NAME = "budgets";

    /**
     * Create a {@link BudgetsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BudgetsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BudgetsAsyncClient}.
     */
    static BudgetsAsyncClientBuilder builder() {
        return new DefaultBudgetsAsyncClientBuilder();
    }

    /**
     * Create a new budget
     *
     * @param createBudgetRequest
     *        Request of CreateBudget
     * @return A Java Future containing the result of the CreateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateBudget
     */
    default CompletableFuture<CreateBudgetResponse> createBudget(CreateBudgetRequest createBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new budget<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBudgetRequest#builder()}
     * </p>
     *
     * @param createBudgetRequest
     *        A {@link Consumer} that will call methods on {@link CreateBudgetRequest.Builder} to create a request.
     *        Request of CreateBudget
     * @return A Java Future containing the result of the CreateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateBudget
     */
    default CompletableFuture<CreateBudgetResponse> createBudget(Consumer<CreateBudgetRequest.Builder> createBudgetRequest) {
        return createBudget(CreateBudgetRequest.builder().applyMutation(createBudgetRequest).build());
    }

    /**
     * Create a new Notification with subscribers for a budget
     *
     * @param createNotificationRequest
     *        Request of CreateNotification
     * @return A Java Future containing the result of the CreateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateNotification
     */
    default CompletableFuture<CreateNotificationResponse> createNotification(CreateNotificationRequest createNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new Notification with subscribers for a budget<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotificationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNotificationRequest#builder()}
     * </p>
     *
     * @param createNotificationRequest
     *        A {@link Consumer} that will call methods on {@link CreateNotificationRequest.Builder} to create a
     *        request. Request of CreateNotification
     * @return A Java Future containing the result of the CreateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateNotification
     */
    default CompletableFuture<CreateNotificationResponse> createNotification(
            Consumer<CreateNotificationRequest.Builder> createNotificationRequest) {
        return createNotification(CreateNotificationRequest.builder().applyMutation(createNotificationRequest).build());
    }

    /**
     * Create a new Subscriber for a notification
     *
     * @param createSubscriberRequest
     *        Request of CreateSubscriber
     * @return A Java Future containing the result of the CreateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateSubscriber
     */
    default CompletableFuture<CreateSubscriberResponse> createSubscriber(CreateSubscriberRequest createSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new Subscriber for a notification<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSubscriberRequest#builder()}
     * </p>
     *
     * @param createSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriberRequest.Builder} to create a request.
     *        Request of CreateSubscriber
     * @return A Java Future containing the result of the CreateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>CreationLimitExceededException The exception is thrown when customer tries to create a record (e.g.
     *         budget), but the number this record already exceeds the limitation.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.CreateSubscriber
     */
    default CompletableFuture<CreateSubscriberResponse> createSubscriber(
            Consumer<CreateSubscriberRequest.Builder> createSubscriberRequest) {
        return createSubscriber(CreateSubscriberRequest.builder().applyMutation(createSubscriberRequest).build());
    }

    /**
     * Delete a budget and related notifications
     *
     * @param deleteBudgetRequest
     *        Request of DeleteBudget
     * @return A Java Future containing the result of the DeleteBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteBudget
     */
    default CompletableFuture<DeleteBudgetResponse> deleteBudget(DeleteBudgetRequest deleteBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a budget and related notifications<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBudgetRequest#builder()}
     * </p>
     *
     * @param deleteBudgetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBudgetRequest.Builder} to create a request.
     *        Request of DeleteBudget
     * @return A Java Future containing the result of the DeleteBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteBudget
     */
    default CompletableFuture<DeleteBudgetResponse> deleteBudget(Consumer<DeleteBudgetRequest.Builder> deleteBudgetRequest) {
        return deleteBudget(DeleteBudgetRequest.builder().applyMutation(deleteBudgetRequest).build());
    }

    /**
     * Delete a notification and related subscribers
     *
     * @param deleteNotificationRequest
     *        Request of DeleteNotification
     * @return A Java Future containing the result of the DeleteNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteNotification
     */
    default CompletableFuture<DeleteNotificationResponse> deleteNotification(DeleteNotificationRequest deleteNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a notification and related subscribers<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNotificationRequest#builder()}
     * </p>
     *
     * @param deleteNotificationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNotificationRequest.Builder} to create a
     *        request. Request of DeleteNotification
     * @return A Java Future containing the result of the DeleteNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteNotification
     */
    default CompletableFuture<DeleteNotificationResponse> deleteNotification(
            Consumer<DeleteNotificationRequest.Builder> deleteNotificationRequest) {
        return deleteNotification(DeleteNotificationRequest.builder().applyMutation(deleteNotificationRequest).build());
    }

    /**
     * Delete a Subscriber for a notification
     *
     * @param deleteSubscriberRequest
     *        Request of DeleteSubscriber
     * @return A Java Future containing the result of the DeleteSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteSubscriber
     */
    default CompletableFuture<DeleteSubscriberResponse> deleteSubscriber(DeleteSubscriberRequest deleteSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a Subscriber for a notification<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSubscriberRequest#builder()}
     * </p>
     *
     * @param deleteSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSubscriberRequest.Builder} to create a request.
     *        Request of DeleteSubscriber
     * @return A Java Future containing the result of the DeleteSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DeleteSubscriber
     */
    default CompletableFuture<DeleteSubscriberResponse> deleteSubscriber(
            Consumer<DeleteSubscriberRequest.Builder> deleteSubscriberRequest) {
        return deleteSubscriber(DeleteSubscriberRequest.builder().applyMutation(deleteSubscriberRequest).build());
    }

    /**
     * Get a single budget
     *
     * @param describeBudgetRequest
     *        Request of DescribeBudget
     * @return A Java Future containing the result of the DescribeBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudget
     */
    default CompletableFuture<DescribeBudgetResponse> describeBudget(DescribeBudgetRequest describeBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a single budget<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBudgetRequest#builder()}
     * </p>
     *
     * @param describeBudgetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBudgetRequest.Builder} to create a request.
     *        Request of DescribeBudget
     * @return A Java Future containing the result of the DescribeBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudget
     */
    default CompletableFuture<DescribeBudgetResponse> describeBudget(Consumer<DescribeBudgetRequest.Builder> describeBudgetRequest) {
        return describeBudget(DescribeBudgetRequest.builder().applyMutation(describeBudgetRequest).build());
    }

    /**
     * Get all budgets for an account
     *
     * @param describeBudgetsRequest
     *        Request of DescribeBudgets
     * @return A Java Future containing the result of the DescribeBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgets
     */
    default CompletableFuture<DescribeBudgetsResponse> describeBudgets(DescribeBudgetsRequest describeBudgetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get all budgets for an account<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBudgetsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBudgetsRequest#builder()}
     * </p>
     *
     * @param describeBudgetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBudgetsRequest.Builder} to create a request.
     *        Request of DescribeBudgets
     * @return A Java Future containing the result of the DescribeBudgets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeBudgets
     */
    default CompletableFuture<DescribeBudgetsResponse> describeBudgets(
            Consumer<DescribeBudgetsRequest.Builder> describeBudgetsRequest) {
        return describeBudgets(DescribeBudgetsRequest.builder().applyMutation(describeBudgetsRequest).build());
    }

    /**
     * Get notifications of a budget
     *
     * @param describeNotificationsForBudgetRequest
     *        Request of DescribeNotificationsForBudget
     * @return A Java Future containing the result of the DescribeNotificationsForBudget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeNotificationsForBudget
     */
    default CompletableFuture<DescribeNotificationsForBudgetResponse> describeNotificationsForBudget(
            DescribeNotificationsForBudgetRequest describeNotificationsForBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get notifications of a budget<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotificationsForBudgetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNotificationsForBudgetRequest#builder()}
     * </p>
     *
     * @param describeNotificationsForBudgetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNotificationsForBudgetRequest.Builder} to
     *        create a request. Request of DescribeNotificationsForBudget
     * @return A Java Future containing the result of the DescribeNotificationsForBudget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeNotificationsForBudget
     */
    default CompletableFuture<DescribeNotificationsForBudgetResponse> describeNotificationsForBudget(
            Consumer<DescribeNotificationsForBudgetRequest.Builder> describeNotificationsForBudgetRequest) {
        return describeNotificationsForBudget(DescribeNotificationsForBudgetRequest.builder()
                .applyMutation(describeNotificationsForBudgetRequest).build());
    }

    /**
     * Get subscribers of a notification
     *
     * @param describeSubscribersForNotificationRequest
     *        Request of DescribeSubscribersForNotification
     * @return A Java Future containing the result of the DescribeSubscribersForNotification operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeSubscribersForNotification
     */
    default CompletableFuture<DescribeSubscribersForNotificationResponse> describeSubscribersForNotification(
            DescribeSubscribersForNotificationRequest describeSubscribersForNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get subscribers of a notification<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscribersForNotificationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSubscribersForNotificationRequest#builder()}
     * </p>
     *
     * @param describeSubscribersForNotificationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubscribersForNotificationRequest.Builder} to
     *        create a request. Request of DescribeSubscribersForNotification
     * @return A Java Future containing the result of the DescribeSubscribersForNotification operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>InvalidNextTokenException This exception is thrown if paging token signature didn't match the token,
     *         or the paging token isn't for this request</li>
     *         <li>ExpiredNextTokenException This exception is thrown if the paging token is expired - past its TTL</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.DescribeSubscribersForNotification
     */
    default CompletableFuture<DescribeSubscribersForNotificationResponse> describeSubscribersForNotification(
            Consumer<DescribeSubscribersForNotificationRequest.Builder> describeSubscribersForNotificationRequest) {
        return describeSubscribersForNotification(DescribeSubscribersForNotificationRequest.builder()
                .applyMutation(describeSubscribersForNotificationRequest).build());
    }

    /**
     * Update the information of a budget already created
     *
     * @param updateBudgetRequest
     *        Request of UpdateBudget
     * @return A Java Future containing the result of the UpdateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateBudget
     */
    default CompletableFuture<UpdateBudgetResponse> updateBudget(UpdateBudgetRequest updateBudgetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update the information of a budget already created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBudgetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateBudgetRequest#builder()}
     * </p>
     *
     * @param updateBudgetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBudgetRequest.Builder} to create a request.
     *        Request of UpdateBudget
     * @return A Java Future containing the result of the UpdateBudget operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateBudget
     */
    default CompletableFuture<UpdateBudgetResponse> updateBudget(Consumer<UpdateBudgetRequest.Builder> updateBudgetRequest) {
        return updateBudget(UpdateBudgetRequest.builder().applyMutation(updateBudgetRequest).build());
    }

    /**
     * Update the information about a notification already created
     *
     * @param updateNotificationRequest
     *        Request of UpdateNotification
     * @return A Java Future containing the result of the UpdateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateNotification
     */
    default CompletableFuture<UpdateNotificationResponse> updateNotification(UpdateNotificationRequest updateNotificationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update the information about a notification already created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNotificationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNotificationRequest#builder()}
     * </p>
     *
     * @param updateNotificationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNotificationRequest.Builder} to create a
     *        request. Request of UpdateNotification
     * @return A Java Future containing the result of the UpdateNotification operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateNotification
     */
    default CompletableFuture<UpdateNotificationResponse> updateNotification(
            Consumer<UpdateNotificationRequest.Builder> updateNotificationRequest) {
        return updateNotification(UpdateNotificationRequest.builder().applyMutation(updateNotificationRequest).build());
    }

    /**
     * Update a subscriber
     *
     * @param updateSubscriberRequest
     *        Request of UpdateSubscriber
     * @return A Java Future containing the result of the UpdateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateSubscriber
     */
    default CompletableFuture<UpdateSubscriberResponse> updateSubscriber(UpdateSubscriberRequest updateSubscriberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a subscriber<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSubscriberRequest#builder()}
     * </p>
     *
     * @param updateSubscriberRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriberRequest.Builder} to create a request.
     *        Request of UpdateSubscriber
     * @return A Java Future containing the result of the UpdateSubscriber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalErrorException This exception is thrown on an unknown internal failure.</li>
     *         <li>InvalidParameterException This exception is thrown if any request is given an invalid parameter.
     *         E.g., if a required Date field is null.</li>
     *         <li>NotFoundException This exception is thrown if a requested entity is not found. E.g., if a budget id
     *         doesn't exist for an account ID.</li>
     *         <li>DuplicateRecordException The exception is thrown when customer tries to create a record (e.g. budget)
     *         that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BudgetsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BudgetsAsyncClient.UpdateSubscriber
     */
    default CompletableFuture<UpdateSubscriberResponse> updateSubscriber(
            Consumer<UpdateSubscriberRequest.Builder> updateSubscriberRequest) {
        return updateSubscriber(UpdateSubscriberRequest.builder().applyMutation(updateSubscriberRequest).build());
    }
}
