/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the output locations for job checkpoint data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobCheckpointConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<JobCheckpointConfig.Builder, JobCheckpointConfig> {
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localPath").getter(getter(JobCheckpointConfig::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localPath").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(JobCheckpointConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOCAL_PATH_FIELD, S3_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String localPath;

    private final String s3Uri;

    private JobCheckpointConfig(BuilderImpl builder) {
        this.localPath = builder.localPath;
        this.s3Uri = builder.s3Uri;
    }

    /**
     * <p>
     * (Optional) The local directory where checkpoints are written. The default directory is
     * <code>/opt/braket/checkpoints/</code>.
     * </p>
     * 
     * @return (Optional) The local directory where checkpoints are written. The default directory is
     *         <code>/opt/braket/checkpoints/</code>.
     */
    public final String localPath() {
        return localPath;
    }

    /**
     * <p>
     * Identifies the S3 path where you want Amazon Braket to store checkpoints. For example,
     * <code>s3://bucket-name/key-name-prefix</code>.
     * </p>
     * 
     * @return Identifies the S3 path where you want Amazon Braket to store checkpoints. For example,
     *         <code>s3://bucket-name/key-name-prefix</code>.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobCheckpointConfig)) {
            return false;
        }
        JobCheckpointConfig other = (JobCheckpointConfig) obj;
        return Objects.equals(localPath(), other.localPath()) && Objects.equals(s3Uri(), other.s3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobCheckpointConfig").add("LocalPath", localPath()).add("S3Uri", s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "localPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("localPath", LOCAL_PATH_FIELD);
        map.put("s3Uri", S3_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobCheckpointConfig, T> g) {
        return obj -> g.apply((JobCheckpointConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobCheckpointConfig> {
        /**
         * <p>
         * (Optional) The local directory where checkpoints are written. The default directory is
         * <code>/opt/braket/checkpoints/</code>.
         * </p>
         * 
         * @param localPath
         *        (Optional) The local directory where checkpoints are written. The default directory is
         *        <code>/opt/braket/checkpoints/</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);

        /**
         * <p>
         * Identifies the S3 path where you want Amazon Braket to store checkpoints. For example,
         * <code>s3://bucket-name/key-name-prefix</code>.
         * </p>
         * 
         * @param s3Uri
         *        Identifies the S3 path where you want Amazon Braket to store checkpoints. For example,
         *        <code>s3://bucket-name/key-name-prefix</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String localPath;

        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(JobCheckpointConfig model) {
            localPath(model.localPath);
            s3Uri(model.s3Uri);
        }

        public final String getLocalPath() {
            return localPath;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        @Override
        public JobCheckpointConfig build() {
            return new JobCheckpointConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
