/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of parameters that specify the input channels, type of input data, and where it is located.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputFileConfig implements SdkPojo, Serializable, ToCopyableBuilder<InputFileConfig.Builder, InputFileConfig> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(InputFileConfig::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(InputFileConfig::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("dataSource").getter(getter(InputFileConfig::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            CONTENT_TYPE_FIELD, DATA_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channelName;

    private final String contentType;

    private final DataSource dataSource;

    private InputFileConfig(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.contentType = builder.contentType;
        this.dataSource = builder.dataSource;
    }

    /**
     * <p>
     * A named input source that an Amazon Braket job can consume.
     * </p>
     * 
     * @return A named input source that an Amazon Braket job can consume.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The MIME type of the data.
     * </p>
     * 
     * @return The MIME type of the data.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The location of the channel data.
     * </p>
     * 
     * @return The location of the channel data.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFileConfig)) {
            return false;
        }
        InputFileConfig other = (InputFileConfig) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(dataSource(), other.dataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputFileConfig").add("ChannelName", channelName()).add("ContentType", contentType())
                .add("DataSource", dataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "dataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("dataSource", DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputFileConfig, T> g) {
        return obj -> g.apply((InputFileConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputFileConfig> {
        /**
         * <p>
         * A named input source that an Amazon Braket job can consume.
         * </p>
         * 
         * @param channelName
         *        A named input source that an Amazon Braket job can consume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The MIME type of the data.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The location of the channel data.
         * </p>
         * 
         * @param dataSource
         *        The location of the channel data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The location of the channel data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String channelName;

        private String contentType;

        private DataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFileConfig model) {
            channelName(model.channelName);
            contentType(model.contentType);
            dataSource(model.dataSource);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public InputFileConfig build() {
            return new InputFileConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
