/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about tasks and jobs queued on a device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceQueueInfo implements SdkPojo, Serializable, ToCopyableBuilder<DeviceQueueInfo.Builder, DeviceQueueInfo> {
    private static final SdkField<String> QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("queue")
            .getter(getter(DeviceQueueInfo::queueAsString)).setter(setter(Builder::queue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()).build();

    private static final SdkField<String> QUEUE_PRIORITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queuePriority").getter(getter(DeviceQueueInfo::queuePriorityAsString))
            .setter(setter(Builder::queuePriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuePriority").build()).build();

    private static final SdkField<String> QUEUE_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueSize").getter(getter(DeviceQueueInfo::queueSize)).setter(setter(Builder::queueSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_FIELD,
            QUEUE_PRIORITY_FIELD, QUEUE_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queue;

    private final String queuePriority;

    private final String queueSize;

    private DeviceQueueInfo(BuilderImpl builder) {
        this.queue = builder.queue;
        this.queuePriority = builder.queuePriority;
        this.queueSize = builder.queueSize;
    }

    /**
     * <p>
     * The name of the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queue} will return
     * {@link QueueName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queueAsString}.
     * </p>
     * 
     * @return The name of the queue.
     * @see QueueName
     */
    public final QueueName queue() {
        return QueueName.fromValue(queue);
    }

    /**
     * <p>
     * The name of the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queue} will return
     * {@link QueueName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queueAsString}.
     * </p>
     * 
     * @return The name of the queue.
     * @see QueueName
     */
    public final String queueAsString() {
        return queue;
    }

    /**
     * <p>
     * Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the tasks in a
     * normal queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queuePriority}
     * will return {@link QueuePriority#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queuePriorityAsString}.
     * </p>
     * 
     * @return Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the tasks
     *         in a normal queue.
     * @see QueuePriority
     */
    public final QueuePriority queuePriority() {
        return QueuePriority.fromValue(queuePriority);
    }

    /**
     * <p>
     * Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the tasks in a
     * normal queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queuePriority}
     * will return {@link QueuePriority#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queuePriorityAsString}.
     * </p>
     * 
     * @return Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the tasks
     *         in a normal queue.
     * @see QueuePriority
     */
    public final String queuePriorityAsString() {
        return queuePriority;
    }

    /**
     * <p>
     * The number of jobs or tasks in the queue for a given device.
     * </p>
     * 
     * @return The number of jobs or tasks in the queue for a given device.
     */
    public final String queueSize() {
        return queueSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queuePriorityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queueSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceQueueInfo)) {
            return false;
        }
        DeviceQueueInfo other = (DeviceQueueInfo) obj;
        return Objects.equals(queueAsString(), other.queueAsString())
                && Objects.equals(queuePriorityAsString(), other.queuePriorityAsString())
                && Objects.equals(queueSize(), other.queueSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceQueueInfo").add("Queue", queueAsString()).add("QueuePriority", queuePriorityAsString())
                .add("QueueSize", queueSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queue":
            return Optional.ofNullable(clazz.cast(queueAsString()));
        case "queuePriority":
            return Optional.ofNullable(clazz.cast(queuePriorityAsString()));
        case "queueSize":
            return Optional.ofNullable(clazz.cast(queueSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queue", QUEUE_FIELD);
        map.put("queuePriority", QUEUE_PRIORITY_FIELD);
        map.put("queueSize", QUEUE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceQueueInfo, T> g) {
        return obj -> g.apply((DeviceQueueInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceQueueInfo> {
        /**
         * <p>
         * The name of the queue.
         * </p>
         * 
         * @param queue
         *        The name of the queue.
         * @see QueueName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueName
         */
        Builder queue(String queue);

        /**
         * <p>
         * The name of the queue.
         * </p>
         * 
         * @param queue
         *        The name of the queue.
         * @see QueueName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueName
         */
        Builder queue(QueueName queue);

        /**
         * <p>
         * Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the tasks in a
         * normal queue.
         * </p>
         * 
         * @param queuePriority
         *        Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the
         *        tasks in a normal queue.
         * @see QueuePriority
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueuePriority
         */
        Builder queuePriority(String queuePriority);

        /**
         * <p>
         * Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the tasks in a
         * normal queue.
         * </p>
         * 
         * @param queuePriority
         *        Optional. Specifies the priority of the queue. Tasks in a priority queue are processed before the
         *        tasks in a normal queue.
         * @see QueuePriority
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueuePriority
         */
        Builder queuePriority(QueuePriority queuePriority);

        /**
         * <p>
         * The number of jobs or tasks in the queue for a given device.
         * </p>
         * 
         * @param queueSize
         *        The number of jobs or tasks in the queue for a given device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueSize(String queueSize);
    }

    static final class BuilderImpl implements Builder {
        private String queue;

        private String queuePriority;

        private String queueSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceQueueInfo model) {
            queue(model.queue);
            queuePriority(model.queuePriority);
            queueSize(model.queueSize);
        }

        public final String getQueue() {
            return queue;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public final Builder queue(QueueName queue) {
            this.queue(queue == null ? null : queue.toString());
            return this;
        }

        public final String getQueuePriority() {
            return queuePriority;
        }

        public final void setQueuePriority(String queuePriority) {
            this.queuePriority = queuePriority;
        }

        @Override
        public final Builder queuePriority(String queuePriority) {
            this.queuePriority = queuePriority;
            return this;
        }

        @Override
        public final Builder queuePriority(QueuePriority queuePriority) {
            this.queuePriority(queuePriority == null ? null : queuePriority.toString());
            return this;
        }

        public final String getQueueSize() {
            return queueSize;
        }

        public final void setQueueSize(String queueSize) {
            this.queueSize = queueSize;
        }

        @Override
        public final Builder queueSize(String queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        @Override
        public DeviceQueueInfo build() {
            return new DeviceQueueInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
