/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.braket.model.Association;
import software.amazon.awssdk.services.braket.model.BraketRequest;
import software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequestAssociationsListCopier;
import software.amazon.awssdk.services.braket.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQuantumTaskRequest
extends BraketRequest
implements ToCopyableBuilder<Builder, CreateQuantumTaskRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::action)).setter(CreateQuantumTaskRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(), JsonValueTrait.create()}).build();
    private static final SdkField<List<Association>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associations").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::associations)).setter(CreateQuantumTaskRequest.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Association::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::clientToken)).setter(CreateQuantumTaskRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceArn").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::deviceArn)).setter(CreateQuantumTaskRequest.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<String> DEVICE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceParameters").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::deviceParameters)).setter(CreateQuantumTaskRequest.setter(Builder::deviceParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceParameters").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> JOB_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobToken").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::jobToken)).setter(CreateQuantumTaskRequest.setter(Builder::jobToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobToken").build()}).build();
    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3Bucket").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::outputS3Bucket)).setter(CreateQuantumTaskRequest.setter(Builder::outputS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()}).build();
    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3KeyPrefix").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::outputS3KeyPrefix)).setter(CreateQuantumTaskRequest.setter(Builder::outputS3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3KeyPrefix").build()}).build();
    private static final SdkField<Long> SHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("shots").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::shots)).setter(CreateQuantumTaskRequest.setter(Builder::shots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateQuantumTaskRequest.getter(CreateQuantumTaskRequest::tags)).setter(CreateQuantumTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ASSOCIATIONS_FIELD, CLIENT_TOKEN_FIELD, DEVICE_ARN_FIELD, DEVICE_PARAMETERS_FIELD, JOB_TOKEN_FIELD, OUTPUT_S3_BUCKET_FIELD, OUTPUT_S3_KEY_PREFIX_FIELD, SHOTS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateQuantumTaskRequest.memberNameToFieldInitializer();
    private final String action;
    private final List<Association> associations;
    private final String clientToken;
    private final String deviceArn;
    private final String deviceParameters;
    private final String jobToken;
    private final String outputS3Bucket;
    private final String outputS3KeyPrefix;
    private final Long shots;
    private final Map<String, String> tags;

    private CreateQuantumTaskRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.associations = builder.associations;
        this.clientToken = builder.clientToken;
        this.deviceArn = builder.deviceArn;
        this.deviceParameters = builder.deviceParameters;
        this.jobToken = builder.jobToken;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.shots = builder.shots;
        this.tags = builder.tags;
    }

    public final String action() {
        return this.action;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<Association> associations() {
        return this.associations;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final String deviceParameters() {
        return this.deviceParameters;
    }

    public final String jobToken() {
        return this.jobToken;
    }

    public final String outputS3Bucket() {
        return this.outputS3Bucket;
    }

    public final String outputS3KeyPrefix() {
        return this.outputS3KeyPrefix;
    }

    public final Long shots() {
        return this.shots;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.shots());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuantumTaskRequest)) {
            return false;
        }
        CreateQuantumTaskRequest other = (CreateQuantumTaskRequest)((Object)obj);
        return Objects.equals(this.action(), other.action()) && this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceParameters(), other.deviceParameters()) && Objects.equals(this.jobToken(), other.jobToken()) && Objects.equals(this.outputS3Bucket(), other.outputS3Bucket()) && Objects.equals(this.outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(this.shots(), other.shots()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateQuantumTaskRequest").add("Action", (Object)this.action()).add("Associations", this.hasAssociations() ? this.associations() : null).add("ClientToken", (Object)this.clientToken()).add("DeviceArn", (Object)this.deviceArn()).add("DeviceParameters", (Object)this.deviceParameters()).add("JobToken", (Object)this.jobToken()).add("OutputS3Bucket", (Object)this.outputS3Bucket()).add("OutputS3KeyPrefix", (Object)this.outputS3KeyPrefix()).add("Shots", (Object)this.shots()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "deviceParameters": {
                return Optional.ofNullable(clazz.cast(this.deviceParameters()));
            }
            case "jobToken": {
                return Optional.ofNullable(clazz.cast(this.jobToken()));
            }
            case "outputS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.outputS3Bucket()));
            }
            case "outputS3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputS3KeyPrefix()));
            }
            case "shots": {
                return Optional.ofNullable(clazz.cast(this.shots()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action", ACTION_FIELD);
        map.put("associations", ASSOCIATIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("deviceArn", DEVICE_ARN_FIELD);
        map.put("deviceParameters", DEVICE_PARAMETERS_FIELD);
        map.put("jobToken", JOB_TOKEN_FIELD);
        map.put("outputS3Bucket", OUTPUT_S3_BUCKET_FIELD);
        map.put("outputS3KeyPrefix", OUTPUT_S3_KEY_PREFIX_FIELD);
        map.put("shots", SHOTS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateQuantumTaskRequest, T> g) {
        return obj -> g.apply((CreateQuantumTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketRequest.BuilderImpl
    implements Builder {
        private String action;
        private List<Association> associations = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String deviceArn;
        private String deviceParameters;
        private String jobToken;
        private String outputS3Bucket;
        private String outputS3KeyPrefix;
        private Long shots;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuantumTaskRequest model) {
            super(model);
            this.action(model.action);
            this.associations(model.associations);
            this.clientToken(model.clientToken);
            this.deviceArn(model.deviceArn);
            this.deviceParameters(model.deviceParameters);
            this.jobToken(model.jobToken);
            this.outputS3Bucket(model.outputS3Bucket);
            this.outputS3KeyPrefix(model.outputS3KeyPrefix);
            this.shots(model.shots);
            this.tags(model.tags);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final List<Association.Builder> getAssociations() {
            List<Association.Builder> result = CreateQuantumTaskRequestAssociationsListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<Association.BuilderImpl> associations) {
            this.associations = CreateQuantumTaskRequestAssociationsListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<Association> associations) {
            this.associations = CreateQuantumTaskRequestAssociationsListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Association ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<Association.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (Association)((Association.Builder)Association.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceParameters() {
            return this.deviceParameters;
        }

        public final void setDeviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
        }

        @Override
        public final Builder deviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
            return this;
        }

        public final String getJobToken() {
            return this.jobToken;
        }

        public final void setJobToken(String jobToken) {
            this.jobToken = jobToken;
        }

        @Override
        public final Builder jobToken(String jobToken) {
            this.jobToken = jobToken;
            return this;
        }

        public final String getOutputS3Bucket() {
            return this.outputS3Bucket;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final String getOutputS3KeyPrefix() {
            return this.outputS3KeyPrefix;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final Long getShots() {
            return this.shots;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQuantumTaskRequest build() {
            return new CreateQuantumTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BraketRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQuantumTaskRequest> {
        public Builder action(String var1);

        public Builder associations(Collection<Association> var1);

        public Builder associations(Association ... var1);

        public Builder associations(Consumer<Association.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder deviceArn(String var1);

        public Builder deviceParameters(String var1);

        public Builder jobToken(String var1);

        public Builder outputS3Bucket(String var1);

        public Builder outputS3KeyPrefix(String var1);

        public Builder shots(Long var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

