/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobRequest extends BraketRequest implements
        ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<AlgorithmSpecification> builder(MarshallingType.SDK_POJO).memberName("algorithmSpecification")
            .getter(getter(CreateJobRequest::algorithmSpecification)).setter(setter(Builder::algorithmSpecification))
            .constructor(AlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmSpecification").build())
            .build();

    private static final SdkField<List<Association>> ASSOCIATIONS_FIELD = SdkField
            .<List<Association>> builder(MarshallingType.LIST)
            .memberName("associations")
            .getter(getter(CreateJobRequest::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Association> builder(MarshallingType.SDK_POJO)
                                            .constructor(Association::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<JobCheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField
            .<JobCheckpointConfig> builder(MarshallingType.SDK_POJO).memberName("checkpointConfig")
            .getter(getter(CreateJobRequest::checkpointConfig)).setter(setter(Builder::checkpointConfig))
            .constructor(JobCheckpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkpointConfig").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<DeviceConfig> DEVICE_CONFIG_FIELD = SdkField.<DeviceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("deviceConfig").getter(getter(CreateJobRequest::deviceConfig)).setter(setter(Builder::deviceConfig))
            .constructor(DeviceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceConfig").build()).build();

    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("hyperParameters")
            .getter(getter(CreateJobRequest::hyperParameters))
            .setter(setter(Builder::hyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<InputFileConfig>> INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<InputFileConfig>> builder(MarshallingType.LIST)
            .memberName("inputDataConfig")
            .getter(getter(CreateJobRequest::inputDataConfig))
            .setter(setter(Builder::inputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputFileConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputFileConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstanceConfig> INSTANCE_CONFIG_FIELD = SdkField
            .<InstanceConfig> builder(MarshallingType.SDK_POJO).memberName("instanceConfig")
            .getter(getter(CreateJobRequest::instanceConfig)).setter(setter(Builder::instanceConfig))
            .constructor(InstanceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfig").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(CreateJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<JobOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<JobOutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(CreateJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(JobOutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<JobStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<JobStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("stoppingCondition")
            .getter(getter(CreateJobRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(JobStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingCondition").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_SPECIFICATION_FIELD,
            ASSOCIATIONS_FIELD, CHECKPOINT_CONFIG_FIELD, CLIENT_TOKEN_FIELD, DEVICE_CONFIG_FIELD, HYPER_PARAMETERS_FIELD,
            INPUT_DATA_CONFIG_FIELD, INSTANCE_CONFIG_FIELD, JOB_NAME_FIELD, OUTPUT_DATA_CONFIG_FIELD, ROLE_ARN_FIELD,
            STOPPING_CONDITION_FIELD, TAGS_FIELD));

    private final AlgorithmSpecification algorithmSpecification;

    private final List<Association> associations;

    private final JobCheckpointConfig checkpointConfig;

    private final String clientToken;

    private final DeviceConfig deviceConfig;

    private final Map<String, String> hyperParameters;

    private final List<InputFileConfig> inputDataConfig;

    private final InstanceConfig instanceConfig;

    private final String jobName;

    private final JobOutputDataConfig outputDataConfig;

    private final String roleArn;

    private final JobStoppingCondition stoppingCondition;

    private final Map<String, String> tags;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.algorithmSpecification = builder.algorithmSpecification;
        this.associations = builder.associations;
        this.checkpointConfig = builder.checkpointConfig;
        this.clientToken = builder.clientToken;
        this.deviceConfig = builder.deviceConfig;
        this.hyperParameters = builder.hyperParameters;
        this.inputDataConfig = builder.inputDataConfig;
        this.instanceConfig = builder.instanceConfig;
        this.jobName = builder.jobName;
        this.outputDataConfig = builder.outputDataConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Definition of the Amazon Braket job to be created. Specifies the container image the job uses and information
     * about the Python scripts used for entry and training.
     * </p>
     * 
     * @return Definition of the Amazon Braket job to be created. Specifies the container image the job uses and
     *         information about the Python scripts used for entry and training.
     */
    public final AlgorithmSpecification algorithmSpecification() {
        return algorithmSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Braket resources associated with the hybrid job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return The list of Amazon Braket resources associated with the hybrid job.
     */
    public final List<Association> associations() {
        return associations;
    }

    /**
     * <p>
     * Information about the output locations for job checkpoint data.
     * </p>
     * 
     * @return Information about the output locations for job checkpoint data.
     */
    public final JobCheckpointConfig checkpointConfig() {
        return checkpointConfig;
    }

    /**
     * <p>
     * A unique token that guarantees that the call to this API is idempotent.
     * </p>
     * 
     * @return A unique token that guarantees that the call to this API is idempotent.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.
     * </p>
     * 
     * @return The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.
     */
    public final DeviceConfig deviceConfig() {
        return deviceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the HyperParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHyperParameters() {
        return hyperParameters != null && !(hyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training job. The
     * values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and the
     * value is the value of th hyperparameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHyperParameters} method.
     * </p>
     * 
     * @return Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training
     *         job. The values are set with a string of JSON key:value pairs, where the key is the name of the
     *         hyperparameter and the value is the value of th hyperparameter.
     */
    public final Map<String, String> hyperParameters() {
        return hyperParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDataConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDataConfig() {
        return inputDataConfig != null && !(inputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameters that specify the name and type of input data and where it is located.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDataConfig} method.
     * </p>
     * 
     * @return A list of parameters that specify the name and type of input data and where it is located.
     */
    public final List<InputFileConfig> inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Configuration of the resource instances to use while running the hybrid job on Amazon Braket.
     * </p>
     * 
     * @return Configuration of the resource instances to use while running the hybrid job on Amazon Braket.
     */
    public final InstanceConfig instanceConfig() {
        return instanceConfig;
    }

    /**
     * <p>
     * The name of the Amazon Braket job.
     * </p>
     * 
     * @return The name of the Amazon Braket job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The path to the S3 location where you want to store job artifacts and the encryption key used to store them.
     * </p>
     * 
     * @return The path to the S3 location where you want to store job artifacts and the encryption key used to store
     *         them.
     */
    public final JobOutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a user.
     * It can access user resources, run an Amazon Braket job container on behalf of user, and output resources to the
     * users' s3 buckets.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of
     *         a user. It can access user resources, run an Amazon Braket job container on behalf of user, and output
     *         resources to the users' s3 buckets.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The user-defined criteria that specifies when a job stops running.
     * </p>
     * 
     * @return The user-defined criteria that specifies when a job stops running.
     */
    public final JobStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket
     *         resources.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperParameters() ? hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDataConfig() ? inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(algorithmSpecification(), other.algorithmSpecification())
                && hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && Objects.equals(checkpointConfig(), other.checkpointConfig())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(deviceConfig(), other.deviceConfig())
                && hasHyperParameters() == other.hasHyperParameters()
                && Objects.equals(hyperParameters(), other.hyperParameters())
                && hasInputDataConfig() == other.hasInputDataConfig()
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(instanceConfig(), other.instanceConfig()) && Objects.equals(jobName(), other.jobName())
                && Objects.equals(outputDataConfig(), other.outputDataConfig()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(stoppingCondition(), other.stoppingCondition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobRequest").add("AlgorithmSpecification", algorithmSpecification())
                .add("Associations", hasAssociations() ? associations() : null).add("CheckpointConfig", checkpointConfig())
                .add("ClientToken", clientToken()).add("DeviceConfig", deviceConfig())
                .add("HyperParameters", hasHyperParameters() ? hyperParameters() : null)
                .add("InputDataConfig", hasInputDataConfig() ? inputDataConfig() : null).add("InstanceConfig", instanceConfig())
                .add("JobName", jobName()).add("OutputDataConfig", outputDataConfig()).add("RoleArn", roleArn())
                .add("StoppingCondition", stoppingCondition()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "algorithmSpecification":
            return Optional.ofNullable(clazz.cast(algorithmSpecification()));
        case "associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "checkpointConfig":
            return Optional.ofNullable(clazz.cast(checkpointConfig()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "deviceConfig":
            return Optional.ofNullable(clazz.cast(deviceConfig()));
        case "hyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        case "inputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "instanceConfig":
            return Optional.ofNullable(clazz.cast(instanceConfig()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "stoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * Definition of the Amazon Braket job to be created. Specifies the container image the job uses and information
         * about the Python scripts used for entry and training.
         * </p>
         * 
         * @param algorithmSpecification
         *        Definition of the Amazon Braket job to be created. Specifies the container image the job uses and
         *        information about the Python scripts used for entry and training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification);

        /**
         * <p>
         * Definition of the Amazon Braket job to be created. Specifies the container image the job uses and information
         * about the Python scripts used for entry and training.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlgorithmSpecification.Builder} avoiding
         * the need to create one manually via {@link AlgorithmSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlgorithmSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #algorithmSpecification(AlgorithmSpecification)}.
         * 
         * @param algorithmSpecification
         *        a consumer that will call methods on {@link AlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmSpecification(AlgorithmSpecification)
         */
        default Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return algorithmSpecification(AlgorithmSpecification.builder().applyMutation(algorithmSpecification).build());
        }

        /**
         * <p>
         * The list of Amazon Braket resources associated with the hybrid job.
         * </p>
         * 
         * @param associations
         *        The list of Amazon Braket resources associated with the hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<Association> associations);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the hybrid job.
         * </p>
         * 
         * @param associations
         *        The list of Amazon Braket resources associated with the hybrid job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Association... associations);

        /**
         * <p>
         * The list of Amazon Braket resources associated with the hybrid job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.Association.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.braket.model.Association#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.Association.Builder#build()} is called immediately and
         * its result is passed to {@link #associations(List<Association>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.Association.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<Association>)
         */
        Builder associations(Consumer<Association.Builder>... associations);

        /**
         * <p>
         * Information about the output locations for job checkpoint data.
         * </p>
         * 
         * @param checkpointConfig
         *        Information about the output locations for job checkpoint data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointConfig(JobCheckpointConfig checkpointConfig);

        /**
         * <p>
         * Information about the output locations for job checkpoint data.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobCheckpointConfig.Builder} avoiding the
         * need to create one manually via {@link JobCheckpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobCheckpointConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #checkpointConfig(JobCheckpointConfig)}.
         * 
         * @param checkpointConfig
         *        a consumer that will call methods on {@link JobCheckpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkpointConfig(JobCheckpointConfig)
         */
        default Builder checkpointConfig(Consumer<JobCheckpointConfig.Builder> checkpointConfig) {
            return checkpointConfig(JobCheckpointConfig.builder().applyMutation(checkpointConfig).build());
        }

        /**
         * <p>
         * A unique token that guarantees that the call to this API is idempotent.
         * </p>
         * 
         * @param clientToken
         *        A unique token that guarantees that the call to this API is idempotent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.
         * </p>
         * 
         * @param deviceConfig
         *        The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceConfig(DeviceConfig deviceConfig);

        /**
         * <p>
         * The quantum processing unit (QPU) or simulator used to create an Amazon Braket job.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceConfig.Builder} avoiding the need
         * to create one manually via {@link DeviceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceConfig(DeviceConfig)}.
         * 
         * @param deviceConfig
         *        a consumer that will call methods on {@link DeviceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceConfig(DeviceConfig)
         */
        default Builder deviceConfig(Consumer<DeviceConfig.Builder> deviceConfig) {
            return deviceConfig(DeviceConfig.builder().applyMutation(deviceConfig).build());
        }

        /**
         * <p>
         * Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training job.
         * The values are set with a string of JSON key:value pairs, where the key is the name of the hyperparameter and
         * the value is the value of th hyperparameter.
         * </p>
         * 
         * @param hyperParameters
         *        Algorithm-specific parameters used by an Amazon Braket job that influence the quality of the training
         *        job. The values are set with a string of JSON key:value pairs, where the key is the name of the
         *        hyperparameter and the value is the value of th hyperparameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(Map<String, String> hyperParameters);

        /**
         * <p>
         * A list of parameters that specify the name and type of input data and where it is located.
         * </p>
         * 
         * @param inputDataConfig
         *        A list of parameters that specify the name and type of input data and where it is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Collection<InputFileConfig> inputDataConfig);

        /**
         * <p>
         * A list of parameters that specify the name and type of input data and where it is located.
         * </p>
         * 
         * @param inputDataConfig
         *        A list of parameters that specify the name and type of input data and where it is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputFileConfig... inputDataConfig);

        /**
         * <p>
         * A list of parameters that specify the name and type of input data and where it is located.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.braket.model.InputFileConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.braket.model.InputFileConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.braket.model.InputFileConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #inputDataConfig(List<InputFileConfig>)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.braket.model.InputFileConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(java.util.Collection<InputFileConfig>)
         */
        Builder inputDataConfig(Consumer<InputFileConfig.Builder>... inputDataConfig);

        /**
         * <p>
         * Configuration of the resource instances to use while running the hybrid job on Amazon Braket.
         * </p>
         * 
         * @param instanceConfig
         *        Configuration of the resource instances to use while running the hybrid job on Amazon Braket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfig(InstanceConfig instanceConfig);

        /**
         * <p>
         * Configuration of the resource instances to use while running the hybrid job on Amazon Braket.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceConfig.Builder} avoiding the need
         * to create one manually via {@link InstanceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceConfig(InstanceConfig)}.
         * 
         * @param instanceConfig
         *        a consumer that will call methods on {@link InstanceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConfig(InstanceConfig)
         */
        default Builder instanceConfig(Consumer<InstanceConfig.Builder> instanceConfig) {
            return instanceConfig(InstanceConfig.builder().applyMutation(instanceConfig).build());
        }

        /**
         * <p>
         * The name of the Amazon Braket job.
         * </p>
         * 
         * @param jobName
         *        The name of the Amazon Braket job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The path to the S3 location where you want to store job artifacts and the encryption key used to store them.
         * </p>
         * 
         * @param outputDataConfig
         *        The path to the S3 location where you want to store job artifacts and the encryption key used to store
         *        them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(JobOutputDataConfig outputDataConfig);

        /**
         * <p>
         * The path to the S3 location where you want to store job artifacts and the encryption key used to store them.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobOutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link JobOutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobOutputDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outputDataConfig(JobOutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link JobOutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(JobOutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<JobOutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(JobOutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf of a
         * user. It can access user resources, run an Amazon Braket job container on behalf of user, and output
         * resources to the users' s3 buckets.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon Braket can assume to perform tasks on behalf
         *        of a user. It can access user resources, run an Amazon Braket job container on behalf of user, and
         *        output resources to the users' s3 buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The user-defined criteria that specifies when a job stops running.
         * </p>
         * 
         * @param stoppingCondition
         *        The user-defined criteria that specifies when a job stops running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(JobStoppingCondition stoppingCondition);

        /**
         * <p>
         * The user-defined criteria that specifies when a job stops running.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link JobStoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobStoppingCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #stoppingCondition(JobStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link JobStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(JobStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<JobStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(JobStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket
         * resources.
         * </p>
         * 
         * @param tags
         *        A tag object that consists of a key and an optional value, used to manage metadata for Amazon Braket
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BraketRequest.BuilderImpl implements Builder {
        private AlgorithmSpecification algorithmSpecification;

        private List<Association> associations = DefaultSdkAutoConstructList.getInstance();

        private JobCheckpointConfig checkpointConfig;

        private String clientToken;

        private DeviceConfig deviceConfig;

        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<InputFileConfig> inputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private InstanceConfig instanceConfig;

        private String jobName;

        private JobOutputDataConfig outputDataConfig;

        private String roleArn;

        private JobStoppingCondition stoppingCondition;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            algorithmSpecification(model.algorithmSpecification);
            associations(model.associations);
            checkpointConfig(model.checkpointConfig);
            clientToken(model.clientToken);
            deviceConfig(model.deviceConfig);
            hyperParameters(model.hyperParameters);
            inputDataConfig(model.inputDataConfig);
            instanceConfig(model.instanceConfig);
            jobName(model.jobName);
            outputDataConfig(model.outputDataConfig);
            roleArn(model.roleArn);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return algorithmSpecification != null ? algorithmSpecification.toBuilder() : null;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final List<Association.Builder> getAssociations() {
            List<Association.Builder> result = CreateJobRequestAssociationsListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<Association.BuilderImpl> associations) {
            this.associations = CreateJobRequestAssociationsListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<Association> associations) {
            this.associations = CreateJobRequestAssociationsListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Association... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<Association.Builder>... associations) {
            associations(Stream.of(associations).map(c -> Association.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final JobCheckpointConfig.Builder getCheckpointConfig() {
            return checkpointConfig != null ? checkpointConfig.toBuilder() : null;
        }

        public final void setCheckpointConfig(JobCheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        @Override
        public final Builder checkpointConfig(JobCheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DeviceConfig.Builder getDeviceConfig() {
            return deviceConfig != null ? deviceConfig.toBuilder() : null;
        }

        public final void setDeviceConfig(DeviceConfig.BuilderImpl deviceConfig) {
            this.deviceConfig = deviceConfig != null ? deviceConfig.build() : null;
        }

        @Override
        public final Builder deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final List<InputFileConfig.Builder> getInputDataConfig() {
            List<InputFileConfig.Builder> result = CreateJobRequestInputDataConfigListCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<InputFileConfig.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = CreateJobRequestInputDataConfigListCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        public final Builder inputDataConfig(Collection<InputFileConfig> inputDataConfig) {
            this.inputDataConfig = CreateJobRequestInputDataConfigListCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(InputFileConfig... inputDataConfig) {
            inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<InputFileConfig.Builder>... inputDataConfig) {
            inputDataConfig(Stream.of(inputDataConfig).map(c -> InputFileConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstanceConfig.Builder getInstanceConfig() {
            return instanceConfig != null ? instanceConfig.toBuilder() : null;
        }

        public final void setInstanceConfig(InstanceConfig.BuilderImpl instanceConfig) {
            this.instanceConfig = instanceConfig != null ? instanceConfig.build() : null;
        }

        @Override
        public final Builder instanceConfig(InstanceConfig instanceConfig) {
            this.instanceConfig = instanceConfig;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final JobOutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(JobOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(JobOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final JobStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(JobStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(JobStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
