/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the queue for a specified job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HybridJobQueueInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<HybridJobQueueInfo.Builder, HybridJobQueueInfo> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(HybridJobQueueInfo::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("position").getter(getter(HybridJobQueueInfo::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<String> QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("queue")
            .getter(getter(HybridJobQueueInfo::queueAsString)).setter(setter(Builder::queue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, POSITION_FIELD,
            QUEUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String position;

    private final String queue;

    private HybridJobQueueInfo(BuilderImpl builder) {
        this.message = builder.message;
        this.position = builder.position;
        this.queue = builder.queue;
    }

    /**
     * <p>
     * Optional. Provides more information about the queue position. For example, if the job is complete and no longer
     * in the queue, the message field contains that information.
     * </p>
     * 
     * @return Optional. Provides more information about the queue position. For example, if the job is complete and no
     *         longer in the queue, the message field contains that information.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Current position of the job in the jobs queue.
     * </p>
     * 
     * @return Current position of the job in the jobs queue.
     */
    public final String position() {
        return position;
    }

    /**
     * <p>
     * The name of the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queue} will return
     * {@link QueueName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queueAsString}.
     * </p>
     * 
     * @return The name of the queue.
     * @see QueueName
     */
    public final QueueName queue() {
        return QueueName.fromValue(queue);
    }

    /**
     * <p>
     * The name of the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queue} will return
     * {@link QueueName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queueAsString}.
     * </p>
     * 
     * @return The name of the queue.
     * @see QueueName
     */
    public final String queueAsString() {
        return queue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(queueAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridJobQueueInfo)) {
            return false;
        }
        HybridJobQueueInfo other = (HybridJobQueueInfo) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(position(), other.position())
                && Objects.equals(queueAsString(), other.queueAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HybridJobQueueInfo").add("Message", message()).add("Position", position())
                .add("Queue", queueAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "queue":
            return Optional.ofNullable(clazz.cast(queueAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HybridJobQueueInfo, T> g) {
        return obj -> g.apply((HybridJobQueueInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HybridJobQueueInfo> {
        /**
         * <p>
         * Optional. Provides more information about the queue position. For example, if the job is complete and no
         * longer in the queue, the message field contains that information.
         * </p>
         * 
         * @param message
         *        Optional. Provides more information about the queue position. For example, if the job is complete and
         *        no longer in the queue, the message field contains that information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Current position of the job in the jobs queue.
         * </p>
         * 
         * @param position
         *        Current position of the job in the jobs queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The name of the queue.
         * </p>
         * 
         * @param queue
         *        The name of the queue.
         * @see QueueName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueName
         */
        Builder queue(String queue);

        /**
         * <p>
         * The name of the queue.
         * </p>
         * 
         * @param queue
         *        The name of the queue.
         * @see QueueName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueName
         */
        Builder queue(QueueName queue);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String position;

        private String queue;

        private BuilderImpl() {
        }

        private BuilderImpl(HybridJobQueueInfo model) {
            message(model.message);
            position(model.position);
            queue(model.queue);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getPosition() {
            return position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final String getQueue() {
            return queue;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public final Builder queue(QueueName queue) {
            this.queue(queue == null ? null : queue.toString());
            return this;
        }

        @Override
        public HybridJobQueueInfo build() {
            return new HybridJobQueueInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
