/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.braket.BraketClientBuilder;
import software.amazon.awssdk.services.braket.BraketServiceClientConfiguration;
import software.amazon.awssdk.services.braket.DefaultBraketClientBuilder;
import software.amazon.awssdk.services.braket.model.AccessDeniedException;
import software.amazon.awssdk.services.braket.model.BraketException;
import software.amazon.awssdk.services.braket.model.CancelJobRequest;
import software.amazon.awssdk.services.braket.model.CancelJobResponse;
import software.amazon.awssdk.services.braket.model.CancelQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.CancelQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.ConflictException;
import software.amazon.awssdk.services.braket.model.CreateJobRequest;
import software.amazon.awssdk.services.braket.model.CreateJobResponse;
import software.amazon.awssdk.services.braket.model.CreateQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.CreateQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.DeviceOfflineException;
import software.amazon.awssdk.services.braket.model.DeviceRetiredException;
import software.amazon.awssdk.services.braket.model.GetDeviceRequest;
import software.amazon.awssdk.services.braket.model.GetDeviceResponse;
import software.amazon.awssdk.services.braket.model.GetJobRequest;
import software.amazon.awssdk.services.braket.model.GetJobResponse;
import software.amazon.awssdk.services.braket.model.GetQuantumTaskRequest;
import software.amazon.awssdk.services.braket.model.GetQuantumTaskResponse;
import software.amazon.awssdk.services.braket.model.InternalServiceException;
import software.amazon.awssdk.services.braket.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.braket.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.braket.model.ResourceNotFoundException;
import software.amazon.awssdk.services.braket.model.SearchDevicesRequest;
import software.amazon.awssdk.services.braket.model.SearchDevicesResponse;
import software.amazon.awssdk.services.braket.model.SearchJobsRequest;
import software.amazon.awssdk.services.braket.model.SearchJobsResponse;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse;
import software.amazon.awssdk.services.braket.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.braket.model.TagResourceRequest;
import software.amazon.awssdk.services.braket.model.TagResourceResponse;
import software.amazon.awssdk.services.braket.model.ThrottlingException;
import software.amazon.awssdk.services.braket.model.UntagResourceRequest;
import software.amazon.awssdk.services.braket.model.UntagResourceResponse;
import software.amazon.awssdk.services.braket.model.ValidationException;
import software.amazon.awssdk.services.braket.paginators.SearchDevicesIterable;
import software.amazon.awssdk.services.braket.paginators.SearchJobsIterable;
import software.amazon.awssdk.services.braket.paginators.SearchQuantumTasksIterable;

@SdkPublicApi
@ThreadSafe
public interface BraketClient
extends AwsClient {
    public static final String SERVICE_NAME = "braket";
    public static final String SERVICE_METADATA_ID = "braket";

    default public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public CancelJobResponse cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) throws ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.cancelJob((CancelJobRequest)((Object)((CancelJobRequest.Builder)CancelJobRequest.builder().applyMutation(cancelJobRequest)).build()));
    }

    default public CancelQuantumTaskResponse cancelQuantumTask(CancelQuantumTaskRequest cancelQuantumTaskRequest) throws ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public CancelQuantumTaskResponse cancelQuantumTask(Consumer<CancelQuantumTaskRequest.Builder> cancelQuantumTaskRequest) throws ResourceNotFoundException, AccessDeniedException, ConflictException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.cancelQuantumTask((CancelQuantumTaskRequest)((Object)((CancelQuantumTaskRequest.Builder)CancelQuantumTaskRequest.builder().applyMutation(cancelQuantumTaskRequest)).build()));
    }

    default public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws ConflictException, AccessDeniedException, ThrottlingException, DeviceRetiredException, InternalServiceException, ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws ConflictException, AccessDeniedException, ThrottlingException, DeviceRetiredException, InternalServiceException, ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.createJob((CreateJobRequest)((Object)((CreateJobRequest.Builder)CreateJobRequest.builder().applyMutation(createJobRequest)).build()));
    }

    default public CreateQuantumTaskResponse createQuantumTask(CreateQuantumTaskRequest createQuantumTaskRequest) throws AccessDeniedException, ThrottlingException, DeviceOfflineException, DeviceRetiredException, InternalServiceException, ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public CreateQuantumTaskResponse createQuantumTask(Consumer<CreateQuantumTaskRequest.Builder> createQuantumTaskRequest) throws AccessDeniedException, ThrottlingException, DeviceOfflineException, DeviceRetiredException, InternalServiceException, ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.createQuantumTask((CreateQuantumTaskRequest)((Object)((CreateQuantumTaskRequest.Builder)CreateQuantumTaskRequest.builder().applyMutation(createQuantumTaskRequest)).build()));
    }

    default public GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public GetDeviceResponse getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.getDevice((GetDeviceRequest)((Object)((GetDeviceRequest.Builder)GetDeviceRequest.builder().applyMutation(getDeviceRequest)).build()));
    }

    default public GetJobResponse getJob(GetJobRequest getJobRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public GetJobResponse getJob(Consumer<GetJobRequest.Builder> getJobRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.getJob((GetJobRequest)((Object)((GetJobRequest.Builder)GetJobRequest.builder().applyMutation(getJobRequest)).build()));
    }

    default public GetQuantumTaskResponse getQuantumTask(GetQuantumTaskRequest getQuantumTaskRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public GetQuantumTaskResponse getQuantumTask(Consumer<GetQuantumTaskRequest.Builder> getQuantumTaskRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.getQuantumTask((GetQuantumTaskRequest)((Object)((GetQuantumTaskRequest.Builder)GetQuantumTaskRequest.builder().applyMutation(getQuantumTaskRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public SearchDevicesResponse searchDevices(SearchDevicesRequest searchDevicesRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public SearchDevicesResponse searchDevices(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.searchDevices((SearchDevicesRequest)((Object)((SearchDevicesRequest.Builder)SearchDevicesRequest.builder().applyMutation(searchDevicesRequest)).build()));
    }

    default public SearchDevicesIterable searchDevicesPaginator(SearchDevicesRequest searchDevicesRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return new SearchDevicesIterable(this, searchDevicesRequest);
    }

    default public SearchDevicesIterable searchDevicesPaginator(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.searchDevicesPaginator((SearchDevicesRequest)((Object)((SearchDevicesRequest.Builder)SearchDevicesRequest.builder().applyMutation(searchDevicesRequest)).build()));
    }

    default public SearchJobsResponse searchJobs(SearchJobsRequest searchJobsRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public SearchJobsResponse searchJobs(Consumer<SearchJobsRequest.Builder> searchJobsRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.searchJobs((SearchJobsRequest)((Object)((SearchJobsRequest.Builder)SearchJobsRequest.builder().applyMutation(searchJobsRequest)).build()));
    }

    default public SearchJobsIterable searchJobsPaginator(SearchJobsRequest searchJobsRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return new SearchJobsIterable(this, searchJobsRequest);
    }

    default public SearchJobsIterable searchJobsPaginator(Consumer<SearchJobsRequest.Builder> searchJobsRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.searchJobsPaginator((SearchJobsRequest)((Object)((SearchJobsRequest.Builder)SearchJobsRequest.builder().applyMutation(searchJobsRequest)).build()));
    }

    default public SearchQuantumTasksResponse searchQuantumTasks(SearchQuantumTasksRequest searchQuantumTasksRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public SearchQuantumTasksResponse searchQuantumTasks(Consumer<SearchQuantumTasksRequest.Builder> searchQuantumTasksRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.searchQuantumTasks((SearchQuantumTasksRequest)((Object)((SearchQuantumTasksRequest.Builder)SearchQuantumTasksRequest.builder().applyMutation(searchQuantumTasksRequest)).build()));
    }

    default public SearchQuantumTasksIterable searchQuantumTasksPaginator(SearchQuantumTasksRequest searchQuantumTasksRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return new SearchQuantumTasksIterable(this, searchQuantumTasksRequest);
    }

    default public SearchQuantumTasksIterable searchQuantumTasksPaginator(Consumer<SearchQuantumTasksRequest.Builder> searchQuantumTasksRequest) throws AccessDeniedException, ThrottlingException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.searchQuantumTasksPaginator((SearchQuantumTasksRequest)((Object)((SearchQuantumTasksRequest.Builder)SearchQuantumTasksRequest.builder().applyMutation(searchQuantumTasksRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, InternalServiceException, ValidationException, AwsServiceException, SdkClientException, BraketException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    public static BraketClient create() {
        return (BraketClient)BraketClient.builder().build();
    }

    public static BraketClientBuilder builder() {
        return new DefaultBraketClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"braket");
    }

    default public BraketServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

