/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.braket.BraketClient;
import software.amazon.awssdk.services.braket.model.QuantumTaskSummary;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse;

public class SearchQuantumTasksIterable
implements SdkIterable<SearchQuantumTasksResponse> {
    private final BraketClient client;
    private final SearchQuantumTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchQuantumTasksIterable(BraketClient client, SearchQuantumTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchQuantumTasksResponseFetcher();
    }

    public Iterator<SearchQuantumTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QuantumTaskSummary> quantumTasks() {
        Function<SearchQuantumTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.quantumTasks() != null) {
                return response.quantumTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchQuantumTasksResponseFetcher
    implements SyncPageFetcher<SearchQuantumTasksResponse> {
        private SearchQuantumTasksResponseFetcher() {
        }

        public boolean hasNextPage(SearchQuantumTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchQuantumTasksResponse nextPage(SearchQuantumTasksResponse previousPage) {
            if (previousPage == null) {
                return SearchQuantumTasksIterable.this.client.searchQuantumTasks(SearchQuantumTasksIterable.this.firstRequest);
            }
            return SearchQuantumTasksIterable.this.client.searchQuantumTasks((SearchQuantumTasksRequest)((Object)SearchQuantumTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

