/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchDevicesResponse extends BraketResponse implements
        ToCopyableBuilder<SearchDevicesResponse.Builder, SearchDevicesResponse> {
    private static final SdkField<List<DeviceSummary>> DEVICES_FIELD = SdkField
            .<List<DeviceSummary>> builder(MarshallingType.LIST)
            .memberName("devices")
            .getter(getter(SearchDevicesResponse::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchDevicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DeviceSummary> devices;

    private final String nextToken;

    private SearchDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.devices = builder.devices;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Devices property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDevices() {
        return devices != null && !(devices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.
     */
    public List<DeviceSummary> devices() {
        return devices;
    }

    /**
     * <p>
     * A token used for pagination of results, or null if there are no additional results. Use the token value in a
     * subsequent request to continue results where the previous request ended.
     * </p>
     * 
     * @return A token used for pagination of results, or null if there are no additional results. Use the token value
     *         in a subsequent request to continue results where the previous request ended.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDevices() ? devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDevicesResponse)) {
            return false;
        }
        SearchDevicesResponse other = (SearchDevicesResponse) obj;
        return hasDevices() == other.hasDevices() && Objects.equals(devices(), other.devices())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchDevicesResponse").add("Devices", hasDevices() ? devices() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devices":
            return Optional.ofNullable(clazz.cast(devices()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchDevicesResponse, T> g) {
        return obj -> g.apply((SearchDevicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchDevicesResponse> {
        /**
         * <p>
         * An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.
         * </p>
         * 
         * @param devices
         *        An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<DeviceSummary> devices);

        /**
         * <p>
         * An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.
         * </p>
         * 
         * @param devices
         *        An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(DeviceSummary... devices);

        /**
         * <p>
         * An array of <code>DeviceSummary</code> objects for devices that match the specified filter values.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceSummary>.Builder} avoiding the need
         * to create one manually via {@link List<DeviceSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #devices(List<DeviceSummary>)}.
         * 
         * @param devices
         *        a consumer that will call methods on {@link List<DeviceSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(List<DeviceSummary>)
         */
        Builder devices(Consumer<DeviceSummary.Builder>... devices);

        /**
         * <p>
         * A token used for pagination of results, or null if there are no additional results. Use the token value in a
         * subsequent request to continue results where the previous request ended.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results, or null if there are no additional results. Use the token
         *        value in a subsequent request to continue results where the previous request ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BraketResponse.BuilderImpl implements Builder {
        private List<DeviceSummary> devices = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDevicesResponse model) {
            super(model);
            devices(model.devices);
            nextToken(model.nextToken);
        }

        public final Collection<DeviceSummary.Builder> getDevices() {
            if (devices instanceof SdkAutoConstructList) {
                return null;
            }
            return devices != null ? devices.stream().map(DeviceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<DeviceSummary> devices) {
            this.devices = DeviceSummaryListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceSummary... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceSummary.Builder>... devices) {
            devices(Stream.of(devices).map(c -> DeviceSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<DeviceSummary.BuilderImpl> devices) {
            this.devices = DeviceSummaryListCopier.copyFromBuilder(devices);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchDevicesResponse build() {
            return new SearchDevicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
