/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQuantumTaskResponse extends BraketResponse implements
        ToCopyableBuilder<GetQuantumTaskResponse.Builder, GetQuantumTaskResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetQuantumTaskResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceArn").getter(getter(GetQuantumTaskResponse::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<String> DEVICE_PARAMETERS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("deviceParameters")
            .getter(getter(GetQuantumTaskResponse::deviceParameters))
            .setter(setter(Builder::deviceParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceParameters").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetQuantumTaskResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetQuantumTaskResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Bucket").getter(getter(GetQuantumTaskResponse::outputS3Bucket))
            .setter(setter(Builder::outputS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()).build();

    private static final SdkField<String> OUTPUT_S3_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Directory").getter(getter(GetQuantumTaskResponse::outputS3Directory))
            .setter(setter(Builder::outputS3Directory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Directory").build()).build();

    private static final SdkField<String> QUANTUM_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quantumTaskArn").getter(getter(GetQuantumTaskResponse::quantumTaskArn))
            .setter(setter(Builder::quantumTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantumTaskArn").build()).build();

    private static final SdkField<Long> SHOTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("shots")
            .getter(getter(GetQuantumTaskResponse::shots)).setter(setter(Builder::shots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetQuantumTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetQuantumTaskResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DEVICE_ARN_FIELD, DEVICE_PARAMETERS_FIELD, ENDED_AT_FIELD, FAILURE_REASON_FIELD, OUTPUT_S3_BUCKET_FIELD,
            OUTPUT_S3_DIRECTORY_FIELD, QUANTUM_TASK_ARN_FIELD, SHOTS_FIELD, STATUS_FIELD, TAGS_FIELD));

    private final Instant createdAt;

    private final String deviceArn;

    private final String deviceParameters;

    private final Instant endedAt;

    private final String failureReason;

    private final String outputS3Bucket;

    private final String outputS3Directory;

    private final String quantumTaskArn;

    private final Long shots;

    private final String status;

    private final Map<String, String> tags;

    private GetQuantumTaskResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.deviceArn = builder.deviceArn;
        this.deviceParameters = builder.deviceParameters;
        this.endedAt = builder.endedAt;
        this.failureReason = builder.failureReason;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3Directory = builder.outputS3Directory;
        this.quantumTaskArn = builder.quantumTaskArn;
        this.shots = builder.shots;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The time at which the task was created.
     * </p>
     * 
     * @return The time at which the task was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ARN of the device the task was run on.
     * </p>
     * 
     * @return The ARN of the device the task was run on.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The parameters for the device on which the task ran.
     * </p>
     * 
     * @return The parameters for the device on which the task ran.
     */
    public String deviceParameters() {
        return deviceParameters;
    }

    /**
     * <p>
     * The time at which the task ended.
     * </p>
     * 
     * @return The time at which the task ended.
     */
    public Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The reason that a task failed.
     * </p>
     * 
     * @return The reason that a task failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The S3 bucket where task results are stored.
     * </p>
     * 
     * @return The S3 bucket where task results are stored.
     */
    public String outputS3Bucket() {
        return outputS3Bucket;
    }

    /**
     * <p>
     * The folder in the S3 bucket where task results are stored.
     * </p>
     * 
     * @return The folder in the S3 bucket where task results are stored.
     */
    public String outputS3Directory() {
        return outputS3Directory;
    }

    /**
     * <p>
     * The ARN of the task.
     * </p>
     * 
     * @return The ARN of the task.
     */
    public String quantumTaskArn() {
        return quantumTaskArn;
    }

    /**
     * <p>
     * The number of shots used in the task.
     * </p>
     * 
     * @return The number of shots used in the task.
     */
    public Long shots() {
        return shots;
    }

    /**
     * <p>
     * The status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuantumTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task.
     * @see QuantumTaskStatus
     */
    public QuantumTaskStatus status() {
        return QuantumTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QuantumTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task.
     * @see QuantumTaskStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that belong to this task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags that belong to this task.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Directory());
        hashCode = 31 * hashCode + Objects.hashCode(quantumTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(shots());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuantumTaskResponse)) {
            return false;
        }
        GetQuantumTaskResponse other = (GetQuantumTaskResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(deviceParameters(), other.deviceParameters()) && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(outputS3Bucket(), other.outputS3Bucket())
                && Objects.equals(outputS3Directory(), other.outputS3Directory())
                && Objects.equals(quantumTaskArn(), other.quantumTaskArn()) && Objects.equals(shots(), other.shots())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetQuantumTaskResponse").add("CreatedAt", createdAt()).add("DeviceArn", deviceArn())
                .add("DeviceParameters", deviceParameters()).add("EndedAt", endedAt()).add("FailureReason", failureReason())
                .add("OutputS3Bucket", outputS3Bucket()).add("OutputS3Directory", outputS3Directory())
                .add("QuantumTaskArn", quantumTaskArn()).add("Shots", shots()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "deviceParameters":
            return Optional.ofNullable(clazz.cast(deviceParameters()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "outputS3Bucket":
            return Optional.ofNullable(clazz.cast(outputS3Bucket()));
        case "outputS3Directory":
            return Optional.ofNullable(clazz.cast(outputS3Directory()));
        case "quantumTaskArn":
            return Optional.ofNullable(clazz.cast(quantumTaskArn()));
        case "shots":
            return Optional.ofNullable(clazz.cast(shots()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQuantumTaskResponse, T> g) {
        return obj -> g.apply((GetQuantumTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQuantumTaskResponse> {
        /**
         * <p>
         * The time at which the task was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ARN of the device the task was run on.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device the task was run on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The parameters for the device on which the task ran.
         * </p>
         * 
         * @param deviceParameters
         *        The parameters for the device on which the task ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceParameters(String deviceParameters);

        /**
         * <p>
         * The time at which the task ended.
         * </p>
         * 
         * @param endedAt
         *        The time at which the task ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The reason that a task failed.
         * </p>
         * 
         * @param failureReason
         *        The reason that a task failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The S3 bucket where task results are stored.
         * </p>
         * 
         * @param outputS3Bucket
         *        The S3 bucket where task results are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Bucket(String outputS3Bucket);

        /**
         * <p>
         * The folder in the S3 bucket where task results are stored.
         * </p>
         * 
         * @param outputS3Directory
         *        The folder in the S3 bucket where task results are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Directory(String outputS3Directory);

        /**
         * <p>
         * The ARN of the task.
         * </p>
         * 
         * @param quantumTaskArn
         *        The ARN of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantumTaskArn(String quantumTaskArn);

        /**
         * <p>
         * The number of shots used in the task.
         * </p>
         * 
         * @param shots
         *        The number of shots used in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shots(Long shots);

        /**
         * <p>
         * The status of the task.
         * </p>
         * 
         * @param status
         *        The status of the task.
         * @see QuantumTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuantumTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task.
         * </p>
         * 
         * @param status
         *        The status of the task.
         * @see QuantumTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuantumTaskStatus
         */
        Builder status(QuantumTaskStatus status);

        /**
         * <p>
         * The tags that belong to this task.
         * </p>
         * 
         * @param tags
         *        The tags that belong to this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends BraketResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String deviceArn;

        private String deviceParameters;

        private Instant endedAt;

        private String failureReason;

        private String outputS3Bucket;

        private String outputS3Directory;

        private String quantumTaskArn;

        private Long shots;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuantumTaskResponse model) {
            super(model);
            createdAt(model.createdAt);
            deviceArn(model.deviceArn);
            deviceParameters(model.deviceParameters);
            endedAt(model.endedAt);
            failureReason(model.failureReason);
            outputS3Bucket(model.outputS3Bucket);
            outputS3Directory(model.outputS3Directory);
            quantumTaskArn(model.quantumTaskArn);
            shots(model.shots);
            status(model.status);
            tags(model.tags);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceParameters() {
            return deviceParameters;
        }

        @Override
        public final Builder deviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
            return this;
        }

        public final void setDeviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getOutputS3Bucket() {
            return outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        public final String getOutputS3Directory() {
            return outputS3Directory;
        }

        @Override
        public final Builder outputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
            return this;
        }

        public final void setOutputS3Directory(String outputS3Directory) {
            this.outputS3Directory = outputS3Directory;
        }

        public final String getQuantumTaskArn() {
            return quantumTaskArn;
        }

        @Override
        public final Builder quantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
            return this;
        }

        public final void setQuantumTaskArn(String quantumTaskArn) {
            this.quantumTaskArn = quantumTaskArn;
        }

        public final Long getShots() {
            return shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QuantumTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public GetQuantumTaskResponse build() {
            return new GetQuantumTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
