/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The guardrail coverage for the text characters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailTextCharactersCoverage implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailTextCharactersCoverage.Builder, GuardrailTextCharactersCoverage> {
    private static final SdkField<Integer> GUARDED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("guarded").getter(getter(GuardrailTextCharactersCoverage::guarded)).setter(setter(Builder::guarded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guarded").build()).build();

    private static final SdkField<Integer> TOTAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("total")
            .getter(getter(GuardrailTextCharactersCoverage::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDED_FIELD, TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer guarded;

    private final Integer total;

    private GuardrailTextCharactersCoverage(BuilderImpl builder) {
        this.guarded = builder.guarded;
        this.total = builder.total;
    }

    /**
     * <p>
     * The text characters that were guarded by the guardrail coverage.
     * </p>
     * 
     * @return The text characters that were guarded by the guardrail coverage.
     */
    public final Integer guarded() {
        return guarded;
    }

    /**
     * <p>
     * The total text characters by the guardrail coverage.
     * </p>
     * 
     * @return The total text characters by the guardrail coverage.
     */
    public final Integer total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guarded());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTextCharactersCoverage)) {
            return false;
        }
        GuardrailTextCharactersCoverage other = (GuardrailTextCharactersCoverage) obj;
        return Objects.equals(guarded(), other.guarded()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailTextCharactersCoverage").add("Guarded", guarded()).add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guarded":
            return Optional.ofNullable(clazz.cast(guarded()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guarded", GUARDED_FIELD);
        map.put("total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTextCharactersCoverage, T> g) {
        return obj -> g.apply((GuardrailTextCharactersCoverage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailTextCharactersCoverage> {
        /**
         * <p>
         * The text characters that were guarded by the guardrail coverage.
         * </p>
         * 
         * @param guarded
         *        The text characters that were guarded by the guardrail coverage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guarded(Integer guarded);

        /**
         * <p>
         * The total text characters by the guardrail coverage.
         * </p>
         * 
         * @param total
         *        The total text characters by the guardrail coverage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Integer total);
    }

    static final class BuilderImpl implements Builder {
        private Integer guarded;

        private Integer total;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTextCharactersCoverage model) {
            guarded(model.guarded);
            total(model.total);
        }

        public final Integer getGuarded() {
            return guarded;
        }

        public final void setGuarded(Integer guarded) {
            this.guarded = guarded;
        }

        @Override
        public final Builder guarded(Integer guarded) {
            this.guarded = guarded;
            return this;
        }

        public final Integer getTotal() {
            return total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        @Override
        public GuardrailTextCharactersCoverage build() {
            return new GuardrailTextCharactersCoverage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
