/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultConverseStreamVisitorBuilder implements ConverseStreamResponseHandler.Visitor.Builder {
    private Consumer<ConverseStreamOutput> onDefault;

    private Consumer<MessageStartEvent> onMessageStart;

    private Consumer<ContentBlockStartEvent> onContentBlockStart;

    private Consumer<ContentBlockDeltaEvent> onContentBlockDelta;

    private Consumer<ContentBlockStopEvent> onContentBlockStop;

    private Consumer<MessageStopEvent> onMessageStop;

    private Consumer<ConverseStreamMetadataEvent> onMetadata;

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onDefault(Consumer<ConverseStreamOutput> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onMessageStart(Consumer<MessageStartEvent> c) {
        this.onMessageStart = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onContentBlockStart(Consumer<ContentBlockStartEvent> c) {
        this.onContentBlockStart = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onContentBlockDelta(Consumer<ContentBlockDeltaEvent> c) {
        this.onContentBlockDelta = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onContentBlockStop(Consumer<ContentBlockStopEvent> c) {
        this.onContentBlockStop = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onMessageStop(Consumer<MessageStopEvent> c) {
        this.onMessageStop = c;
        return this;
    }

    @Override
    public ConverseStreamResponseHandler.Visitor.Builder onMetadata(Consumer<ConverseStreamMetadataEvent> c) {
        this.onMetadata = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements ConverseStreamResponseHandler.Visitor {
        private final Consumer<ConverseStreamOutput> onDefault;

        private final Consumer<MessageStartEvent> onMessageStart;

        private final Consumer<ContentBlockStartEvent> onContentBlockStart;

        private final Consumer<ContentBlockDeltaEvent> onContentBlockDelta;

        private final Consumer<ContentBlockStopEvent> onContentBlockStop;

        private final Consumer<MessageStopEvent> onMessageStop;

        private final Consumer<ConverseStreamMetadataEvent> onMetadata;

        VisitorFromBuilder(DefaultConverseStreamVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : ConverseStreamResponseHandler.Visitor.super::visitDefault;
            this.onMessageStart = builder.onMessageStart != null ? builder.onMessageStart
                    : ConverseStreamResponseHandler.Visitor.super::visitMessageStart;
            this.onContentBlockStart = builder.onContentBlockStart != null ? builder.onContentBlockStart
                    : ConverseStreamResponseHandler.Visitor.super::visitContentBlockStart;
            this.onContentBlockDelta = builder.onContentBlockDelta != null ? builder.onContentBlockDelta
                    : ConverseStreamResponseHandler.Visitor.super::visitContentBlockDelta;
            this.onContentBlockStop = builder.onContentBlockStop != null ? builder.onContentBlockStop
                    : ConverseStreamResponseHandler.Visitor.super::visitContentBlockStop;
            this.onMessageStop = builder.onMessageStop != null ? builder.onMessageStop
                    : ConverseStreamResponseHandler.Visitor.super::visitMessageStop;
            this.onMetadata = builder.onMetadata != null ? builder.onMetadata
                    : ConverseStreamResponseHandler.Visitor.super::visitMetadata;
        }

        @Override
        public void visitDefault(ConverseStreamOutput event) {
            onDefault.accept(event);
        }

        @Override
        public void visitMessageStart(MessageStartEvent event) {
            onMessageStart.accept(event);
        }

        @Override
        public void visitContentBlockStart(ContentBlockStartEvent event) {
            onContentBlockStart.accept(event);
        }

        @Override
        public void visitContentBlockDelta(ContentBlockDeltaEvent event) {
            onContentBlockDelta.accept(event);
        }

        @Override
        public void visitContentBlockStop(ContentBlockStopEvent event) {
            onContentBlockStop.accept(event);
        }

        @Override
        public void visitMessageStop(MessageStopEvent event) {
            onMessageStop.accept(event);
        }

        @Override
        public void visitMetadata(ConverseStreamMetadataEvent event) {
            onMetadata.accept(event);
        }
    }
}
